/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.Bind;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.DescribeModeEnum;
import com.bigdata.rdf.sparql.ast.QueryNodeBase;
import com.bigdata.rdf.sparql.ast.ValueExpressionListBaseNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProjectionNode
extends ValueExpressionListBaseNode<AssignmentNode> {
    private static final long serialVersionUID = 1L;

    public ProjectionNode() {
    }

    public ProjectionNode(ProjectionNode op) {
        super(op);
    }

    public ProjectionNode(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    public void setDistinct(boolean distinct) {
        this.setProperty("distinct", distinct);
    }

    public boolean isDistinct() {
        return this.getProperty("distinct", false);
    }

    public void setReduced(boolean reduced) {
        this.setProperty("reduced", reduced);
    }

    public boolean isReduced() {
        return this.getProperty("reduced", false);
    }

    public boolean isWildcard() {
        if (this.isEmpty()) {
            return false;
        }
        return ((AssignmentNode)this.getExpr(0)).getVar().isWildcard();
    }

    public DescribeModeEnum getDescribeMode() {
        return (DescribeModeEnum)((Object)this.getProperty("describeMode"));
    }

    public void setDescribeMode(DescribeModeEnum describeMode) {
        this.setProperty("describeMode", (Object)describeMode);
    }

    public Integer getDescribeIterationLimit() {
        return (Integer)this.getProperty("describeIterationLimit");
    }

    public Integer getDescribeStatementLimit() {
        return (Integer)this.getProperty("describeStatementLimit");
    }

    public void setDescribeIterationLimit(int newValue) {
        this.setProperty("describeIterationLimit", newValue);
    }

    public void setDescribeStatementLimit(int newValue) {
        this.setProperty("describeStatementLimit", newValue);
    }

    public void addProjectionVar(VarNode var) {
        this.addExpr(new AssignmentNode(var, var));
    }

    public void addProjectionExpression(AssignmentNode assignment) {
        this.addExpr(assignment);
    }

    public List<AssignmentNode> getAssignmentProjections() {
        LinkedList<AssignmentNode> assignments = new LinkedList<AssignmentNode>();
        for (AssignmentNode n : this) {
            if (n.getValueExpressionNode().equals(n.getVarNode())) continue;
            assignments.add(n);
        }
        return assignments;
    }

    public IVariable[] getProjectionVars() {
        LinkedHashSet vars = new LinkedHashSet();
        this.getProjectionVars(vars);
        return vars.toArray(new IVariable[vars.size()]);
    }

    public Set<IVariable<?>> getProjectionVars(Set<IVariable<?>> vars) {
        for (AssignmentNode n : this) {
            vars.add(n.getVar());
        }
        return vars;
    }

    public Set<IVariable<?>> getSelectExprVars(Set<IVariable<?>> vars) {
        for (AssignmentNode n : this) {
            Iterator<IVariable<?>> itr = BOpUtility.getSpannedVariables(n.getValueExpression());
            while (itr.hasNext()) {
                vars.add(itr.next());
            }
        }
        return vars;
    }

    public IValueExpression[] getValueExpressions() {
        IValueExpression[] exprs = new IValueExpression[this.size()];
        int i = 0;
        for (AssignmentNode n : this) {
            exprs[i++] = new Bind<IV>(n.getVar(), n.getValueExpression());
        }
        return exprs;
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append(ProjectionNode.indent(indent)).append("SELECT ");
        if (this.isDistinct()) {
            sb.append("DISTINCT ");
        }
        if (this.isReduced()) {
            sb.append("REDUCED ");
        }
        DescribeModeEnum describeMode = this.getDescribeMode();
        Integer describeIterationLimit = this.getDescribeIterationLimit();
        Integer describeStatementLimit = this.getDescribeStatementLimit();
        if (describeMode != null) {
            sb.append("[describeMode=" + (Object)((Object)describeMode) + "]");
        }
        if (describeIterationLimit != null) {
            sb.append("[describeIterationLimit=" + describeIterationLimit + "]");
        }
        if (describeStatementLimit != null) {
            sb.append("[describeStatement=" + describeStatementLimit + "]");
        }
        if (this.isWildcard()) {
            sb.append("* ");
        } else {
            boolean first = true;
            for (AssignmentNode v : this) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" ");
                }
                sb.append(v);
            }
        }
        return sb.toString();
    }

    static interface Annotations
    extends QueryNodeBase.Annotations {
        public static final String DISTINCT = "distinct";
        public static final boolean DEFAULT_DISTINCT = false;
        public static final String REDUCED = "reduced";
        public static final boolean DEFAULT_REDUCED = false;
        public static final String DESCRIBE_MODE = "describeMode";
        public static final String DESCRIBE_ITERATION_LIMIT = "describeIterationLimit";
        public static final String DESCRIBE_STATEMENT_LIMIT = "describeStatementLimit";
    }
}

