/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.lbs.policy.ganglia;

import com.bigdata.ganglia.GangliaService;
import com.bigdata.ganglia.IHostReport;
import com.bigdata.journal.GangliaPlugIn;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.rdf.sail.webapp.lbs.AbstractHostLBSPolicy;
import com.bigdata.rdf.sail.webapp.lbs.IHostMetrics;
import com.bigdata.rdf.sail.webapp.lbs.IHostScoringRule;
import com.bigdata.rdf.sail.webapp.lbs.ServiceScore;
import com.bigdata.rdf.sail.webapp.lbs.policy.ganglia.DefaultHostScoringRule;
import com.bigdata.rdf.sail.webapp.lbs.policy.ganglia.GangliaHostMetricWrapper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public class GangliaLBSPolicy
extends AbstractHostLBSPolicy {
    private static final Logger log = Logger.getLogger(GangliaLBSPolicy.class);
    private static final long serialVersionUID = 1L;
    private final AtomicReference<GangliaService> gangliaServiceRef = new AtomicReference();

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(",gangliaService=" + this.gangliaServiceRef.get());
    }

    @Override
    public void init(ServletConfig servletConfig, IIndexManager indexManager) throws ServletException {
        super.init(servletConfig, indexManager);
        this.gangliaServiceRef.set((GangliaService)((Journal)indexManager).getGangliaService());
        if (this.gangliaServiceRef.get() == null) {
            throw new ServletException("LBS requires " + GangliaPlugIn.class.getName());
        }
    }

    @Override
    public void destroy() {
        this.gangliaServiceRef.set(null);
        super.destroy();
    }

    @Override
    protected Map<String, IHostMetrics> getHostReportForKnownServices(IHostScoringRule scoringRule, ServiceScore[] serviceScores) {
        GangliaService gangliaService = this.gangliaServiceRef.get();
        if (gangliaService == null) {
            return null;
        }
        LinkedList<String> tmp = new LinkedList<String>();
        for (ServiceScore serviceScore : serviceScores) {
            String hostname;
            if (serviceScore == null || (hostname = serviceScore.getHostname()) == null) continue;
            tmp.add(hostname);
        }
        String[] hosts = tmp.toArray(new String[tmp.size()]);
        String[] reportOn = scoringRule.getMetricNames();
        IHostReport[] hostReport = gangliaService.getHostReport(hosts, reportOn, null);
        HashMap<String, IHostMetrics> hostMetricsMap = new HashMap<String, IHostMetrics>();
        block1: for (int i = 0; i < hostReport.length; ++i) {
            IHostReport theHostReport = hostReport[i];
            for (int j = 0; j < serviceScores.length; ++j) {
                String localname;
                ServiceScore theServiceScore = serviceScores[j];
                String hostname = theServiceScore.getHostname();
                if (hostname == null) continue;
                int index = hostname.indexOf(46);
                String string = localname = index == -1 ? null : hostname.substring(0, index);
                if (hostname.equals(theHostReport.getHostName())) {
                    hostMetricsMap.put(hostname, new GangliaHostMetricWrapper(theHostReport));
                    continue block1;
                }
                if (!localname.equals(theHostReport.getHostName())) continue;
                hostMetricsMap.put(hostname, new GangliaHostMetricWrapper(theHostReport));
                continue block1;
            }
        }
        return hostMetricsMap;
    }

    @Override
    protected String getDefaultScoringRule() {
        return DefaultHostScoringRule.class.getName();
    }

    public static interface InitParams
    extends AbstractHostLBSPolicy.InitParams {
    }
}

