/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.lbs.policy.counters;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounter;
import com.bigdata.counters.ICounterNode;
import com.bigdata.rdf.sail.webapp.lbs.AbstractHostMetrics;
import java.util.Iterator;
import java.util.LinkedList;

public class CounterSetHostMetricsWrapper
extends AbstractHostMetrics {
    private final CounterSet counterSet;

    public String toString() {
        return this.getClass().getName() + "{counters=" + this.counterSet + "}";
    }

    public CounterSetHostMetricsWrapper(CounterSet counterSet) {
        if (counterSet == null) {
            throw new IllegalArgumentException();
        }
        this.counterSet = counterSet;
    }

    @Override
    public String[] getMetricNames() {
        LinkedList<String> list = new LinkedList<String>();
        Iterator<ICounter> itr = this.counterSet.getCounters(null);
        while (itr.hasNext()) {
            ICounter c = itr.next();
            String path = c.getPath();
            list.add(path);
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Number getNumeric(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        ICounterNode c = this.counterSet.getPath(name);
        if (c == null) {
            return null;
        }
        if (!c.isCounter()) {
            return null;
        }
        return (Number)((ICounter)c).getValue();
    }
}

