/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.rdf.sail.sparql.ASTVisitorBase;
import com.bigdata.rdf.sail.sparql.ast.ASTBasicGraphPattern;
import com.bigdata.rdf.sail.sparql.ast.ASTBlankNode;
import com.bigdata.rdf.sail.sparql.ast.ASTBlankNodePropertyList;
import com.bigdata.rdf.sail.sparql.ast.ASTCollection;
import com.bigdata.rdf.sail.sparql.ast.ASTOperationContainer;
import com.bigdata.rdf.sail.sparql.ast.ASTVar;
import com.bigdata.rdf.sail.sparql.ast.Node;
import com.bigdata.rdf.sail.sparql.ast.SyntaxTreeBuilderVisitor;
import com.bigdata.rdf.sail.sparql.ast.VisitorException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.query.MalformedQueryException;

public class BlankNodeVarProcessor
extends ASTVisitorBase {
    public static Set<String> process(ASTOperationContainer qc) throws MalformedQueryException {
        try {
            BlankNodeToVarConverter converter = new BlankNodeToVarConverter();
            qc.jjtAccept((SyntaxTreeBuilderVisitor)converter, null);
            return converter.getUsedBNodeIDs();
        }
        catch (VisitorException e) {
            throw new MalformedQueryException((Throwable)e);
        }
    }

    private static class BlankNodeToVarConverter
    extends ASTVisitorBase {
        private int anonVarNo = 1;
        private Map<String, String> conversionMap = new HashMap<String, String>();
        private Set<String> usedBNodeIDs = new HashSet<String>();

        private BlankNodeToVarConverter() {
        }

        private String createAnonVarName() {
            return "-anon-" + this.anonVarNo++;
        }

        public Set<String> getUsedBNodeIDs() {
            this.usedBNodeIDs.addAll(this.conversionMap.keySet());
            return Collections.unmodifiableSet(this.usedBNodeIDs);
        }

        @Override
        public Object visit(ASTBasicGraphPattern node, Object data) throws VisitorException {
            this.usedBNodeIDs.addAll(this.conversionMap.keySet());
            this.conversionMap.clear();
            return super.visit(node, data);
        }

        @Override
        public Object visit(ASTBlankNode node, Object data) throws VisitorException {
            String bnodeID = node.getID();
            String varName = this.findVarName(bnodeID);
            if (varName == null) {
                varName = this.createAnonVarName();
                if (bnodeID != null) {
                    this.conversionMap.put(bnodeID, varName);
                }
            }
            ASTVar varNode = new ASTVar(51);
            varNode.setName(varName);
            varNode.setAnonymous(true);
            node.jjtReplaceWith((Node)varNode);
            return super.visit(node, data);
        }

        private String findVarName(String bnodeID) throws VisitorException {
            if (bnodeID == null) {
                return null;
            }
            String varName = this.conversionMap.get(bnodeID);
            if (varName == null && this.usedBNodeIDs.contains(bnodeID)) {
                throw new VisitorException("BNodeID already used in another scope: " + bnodeID);
            }
            return varName;
        }

        @Override
        public Object visit(ASTBlankNodePropertyList node, Object data) throws VisitorException {
            node.setVarName(this.createAnonVarName());
            return super.visit(node, data);
        }

        @Override
        public Object visit(ASTCollection node, Object data) throws VisitorException {
            node.setVarName(this.createAnonVarName());
            return super.visit(node, data);
        }
    }
}

