/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.config;

import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.config.BigdataSailConfig;
import java.util.Properties;
import org.openrdf.sail.Sail;
import org.openrdf.sail.config.SailConfigException;
import org.openrdf.sail.config.SailFactory;
import org.openrdf.sail.config.SailImplConfig;

public class BigdataSailFactory
implements SailFactory {
    public static final String TYPE = "bigdata:BigdataSail";

    public String getSailType() {
        return TYPE;
    }

    public SailImplConfig getConfig() {
        return new BigdataSailConfig(TYPE);
    }

    public Sail getSail(SailImplConfig config) throws SailConfigException {
        if (!TYPE.equals(config.getType())) {
            throw new SailConfigException("Invalid type: " + config.getType());
        }
        if (!(config instanceof BigdataSailConfig)) {
            throw new SailConfigException("Invalid type: " + config.getClass());
        }
        try {
            BigdataSailConfig bigdataConfig = (BigdataSailConfig)config;
            Properties properties = bigdataConfig.getProperties();
            return new BigdataSail(properties);
        }
        catch (Exception ex) {
            throw new SailConfigException((Throwable)ex);
        }
    }
}

