/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.sail.webapp.DatasetNotFoundException;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.task.AbstractApiTask;
import org.apache.log4j.Logger;

public class DestroyKBTask
extends AbstractApiTask<Void> {
    private static final transient Logger log = Logger.getLogger(DestroyKBTask.class);

    public DestroyKBTask(String namespace) {
        super(namespace, 0L, true);
    }

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception, DatasetNotFoundException {
        IIndexManager indexManager = this.getIndexManager();
        boolean isGroupCommit = indexManager.isGroupCommit();
        boolean acquiredConnection = false;
        try {
            AbstractTripleStore tripleStore;
            if (!isGroupCommit) {
                try {
                    ((Journal)indexManager).acquireUnisolatedConnection();
                    acquiredConnection = true;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            if ((tripleStore = this.getTripleStore()) == null) {
                throw new DatasetNotFoundException("Not found: namespace=" + this.namespace + ", timestamp=" + TimestampUtility.toString(this.timestamp));
            }
            tripleStore.destroy();
            tripleStore.commit();
            if (log.isInfoEnabled()) {
                log.info((Object)("Destroyed: namespace=" + this.namespace));
            }
            Void void_ = null;
            return void_;
        }
        finally {
            if (!isGroupCommit && acquiredConnection) {
                ((Journal)indexManager).releaseUnisolatedConnection();
            }
        }
    }
}

