/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.model;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.bnode.SidIV;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.ModifiedEnum;
import com.bigdata.rdf.store.IRawTripleStore;
import org.openrdf.model.Statement;

public class BigdataStatementImpl
implements BigdataStatement {
    private static final long serialVersionUID = 6739949195958368365L;
    private final BigdataResource s;
    private final BigdataURI p;
    private final BigdataValue o;
    private final BigdataResource c;
    private IV sid = null;
    private StatementEnum type;
    private boolean userFlag;
    private transient boolean override = false;
    private transient ModifiedEnum modified = ModifiedEnum.NONE;
    private int hash = 0;

    public BigdataStatementImpl(BigdataResource subject, BigdataURI predicate, BigdataValue object, BigdataResource context, StatementEnum type, boolean userFlag) {
        if (subject == null) {
            throw new IllegalArgumentException();
        }
        if (predicate == null) {
            throw new IllegalArgumentException();
        }
        if (object == null) {
            throw new IllegalArgumentException();
        }
        this.s = subject;
        this.p = predicate;
        this.o = object;
        this.c = context;
        this.type = type;
        this.userFlag = userFlag;
    }

    @Override
    public final BigdataResource getSubject() {
        return this.s;
    }

    @Override
    public final BigdataURI getPredicate() {
        return this.p;
    }

    @Override
    public final BigdataValue getObject() {
        return this.o;
    }

    @Override
    public final BigdataResource getContext() {
        return this.c;
    }

    @Override
    public final boolean hasStatementType() {
        return this.type != null;
    }

    @Override
    public final StatementEnum getStatementType() {
        return this.type;
    }

    @Override
    public final void setStatementType(StatementEnum type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (this.type != null && type != this.type) {
            throw new IllegalStateException();
        }
        this.type = type;
    }

    @Override
    public final void setUserFlag(boolean userFlag) {
        this.userFlag = userFlag;
    }

    @Override
    public final boolean isAxiom() {
        return StatementEnum.Axiom == this.type;
    }

    @Override
    public final boolean isInferred() {
        return StatementEnum.Inferred == this.type;
    }

    @Override
    public final boolean isExplicit() {
        return StatementEnum.Explicit == this.type;
    }

    @Override
    public final boolean getUserFlag() {
        return this.userFlag;
    }

    public boolean equals(Object o) {
        return this.equals((Statement)o);
    }

    public boolean equals(Statement stmt) {
        return this.s.equals(stmt.getSubject()) && this.p.equals(stmt.getPredicate()) && this.o.equals(stmt.getObject());
    }

    public final int hashCode() {
        if (this.hash == 0) {
            this.hash = 961 * this.s.hashCode() + 31 * this.p.hashCode() + this.o.hashCode();
        }
        return this.hash;
    }

    public String toString() {
        return "<" + this.s + ", " + this.p + ", " + this.o + (this.c == null ? "" : ", " + this.c) + ">" + (this.type == null ? "" : " : " + (Object)((Object)this.type)) + (this.isModified() ? " : modified(" + (Object)((Object)this.modified) + ")" : "");
    }

    @Override
    public final IV s() {
        return this.s.getIV();
    }

    @Override
    public final IV p() {
        return this.p.getIV();
    }

    @Override
    public final IV o() {
        return this.o.getIV();
    }

    @Override
    public final IV c() {
        if (this.c == null) {
            return null;
        }
        return this.c.getIV();
    }

    @Override
    public IV get(int index) {
        switch (index) {
            case 0: {
                return this.s.getIV();
            }
            case 1: {
                return this.p.getIV();
            }
            case 2: {
                return this.o.getIV();
            }
            case 3: {
                return this.c == null ? null : this.c.getIV();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public final boolean isFullyBound() {
        return this.s() != null && this.p() != null && this.o() != null;
    }

    @Override
    public final IV getStatementIdentifier() {
        if (this.sid == null && this.type == StatementEnum.Explicit) {
            this.sid = new SidIV(this);
        }
        return this.sid;
    }

    @Override
    public final boolean hasStatementIdentifier() {
        return this.type == StatementEnum.Explicit;
    }

    @Override
    public final boolean isOverride() {
        return this.override;
    }

    @Override
    public final void setOverride(boolean override) {
        this.override = override;
    }

    @Override
    public String toString(IRawTripleStore storeIsIgnored) {
        return this.toString();
    }

    @Override
    public boolean isModified() {
        return this.modified != ModifiedEnum.NONE;
    }

    @Override
    public void setModified(ModifiedEnum modified) {
        this.modified = modified;
    }

    @Override
    public ModifiedEnum getModified() {
        return this.modified;
    }
}

