/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.model;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.bnode.SidIV;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataResourceImpl;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.rio.UnificationException;
import com.bigdata.rdf.spo.SPO;
import org.openrdf.model.BNode;

public class BigdataBNodeImpl
extends BigdataResourceImpl
implements BigdataBNode {
    private static final long serialVersionUID = 2675602437833048872L;
    private final String id;
    private boolean statementIdentifier;
    private transient boolean selfRef = false;
    private transient BigdataStatement sid;

    BigdataBNodeImpl(BigdataValueFactory valueFactory, String id) {
        this(valueFactory, id, null);
    }

    BigdataBNodeImpl(BigdataValueFactory valueFactory, String id, BigdataStatement stmt) {
        super(valueFactory, null);
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.sid = stmt;
        if (stmt != null) {
            this.statementIdentifier = true;
        }
    }

    @Override
    public IV getIV() {
        if (this.iv == null && this.sid != null) {
            if (this.selfRef) {
                throw new UnificationException("illegal self-referential sid");
            }
            this.selfRef = true;
            IV s = this.sid.s();
            IV p = this.sid.p();
            IV o = this.sid.o();
            this.selfRef = false;
            if (s != null && p != null && o != null) {
                this.setIV(new SidIV(new SPO(s, p, o)));
            }
        }
        return this.iv;
    }

    public String toString() {
        if (this.sid != null) {
            return "<" + this.sid.toString() + ">";
        }
        return "_:" + this.id;
    }

    public String stringValue() {
        return this.id;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof BNode)) {
            return false;
        }
        return this.equals((BNode)o);
    }

    public final boolean equals(BNode o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof BigdataValue && this.isRealIV() && ((BigdataValue)o).isRealIV() && ((BigdataValue)o).getValueFactory() == this.getValueFactory()) {
            return this.getIV().equals(((BigdataValue)o).getIV());
        }
        return this.id.equals(o.getID());
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final String getID() {
        return this.id;
    }

    @Override
    public final void setStatementIdentifier(boolean isStmtIdentifier) {
        this.statementIdentifier = isStmtIdentifier;
    }

    @Override
    public final boolean isStatementIdentifier() {
        return this.statementIdentifier;
    }

    @Override
    public final void setStatement(BigdataStatement sid) {
        this.statementIdentifier = true;
        this.sid = sid;
    }

    @Override
    public final BigdataStatement getStatement() {
        return this.sid;
    }
}

