/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.keys.DefaultKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilderFactory;
import com.bigdata.btree.raba.codec.FixedLengthValueRabaCoder;
import com.bigdata.io.ByteArrayBuffer;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.lexicon.LexiconKeyBuilder;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import org.openrdf.model.Value;

public class Term2IdTupleSerializer
extends DefaultTupleSerializer {
    private static final long serialVersionUID = 1486882823994548034L;
    private static final transient byte VERSION0 = 0;
    private static final transient byte VERSION = 0;

    public Term2IdTupleSerializer() {
    }

    public Term2IdTupleSerializer(Properties properties) {
        this(new DefaultKeyBuilderFactory(properties));
    }

    public Term2IdTupleSerializer(IKeyBuilderFactory keyBuilderFactory) {
        super(keyBuilderFactory, Term2IdTupleSerializer.getDefaultLeafKeysCoder(), new FixedLengthValueRabaCoder(9));
    }

    public LexiconKeyBuilder getLexiconKeyBuilder() {
        return new LexiconKeyBuilder(this.getKeyBuilder());
    }

    public LexiconKeyBuilder getLexiconPrimaryKeyBuilder() {
        return new LexiconKeyBuilder(this.getPrimaryKeyBuilder());
    }

    @Override
    public Object deserializeKey(ITuple tuple) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] serializeKey(Object obj) {
        return this.getLexiconKeyBuilder().value2Key((Value)obj);
    }

    @Override
    public byte[] serializeVal(Object obj) {
        IV iv = (IV)obj;
        byte[] key = iv.encode(this.getKeyBuilder()).getKey();
        return key;
    }

    @Override
    public IV deserialize(ITuple tuple) {
        ByteArrayBuffer b = tuple.getValueBuffer();
        return IVUtility.decodeFromOffset(b.array(), 0);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte version = in.readByte();
        switch (version) {
            case 0: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown version: " + version);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(0);
    }
}

