/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.keys.KVO;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.BlobIV;
import com.bigdata.rdf.lexicon.AssignTermId;
import com.bigdata.rdf.lexicon.BlobsIndexHelper;
import com.bigdata.rdf.lexicon.BlobsWriteProc;
import com.bigdata.rdf.lexicon.WriteTaskStats;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.service.Split;
import com.bigdata.service.ndx.pipeline.KVOList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class BlobsWriteTask
implements Callable<KVO<BigdataValue>[]> {
    private static final transient Logger log = Logger.getLogger(BlobsWriteTask.class);
    final IIndex ndx;
    final BigdataValueFactory valueFactory;
    private final boolean readOnly;
    private final boolean storeBlankNodes;
    private final int numTerms;
    private final BigdataValue[] terms;
    private final WriteTaskStats stats;

    public BlobsWriteTask(IIndex ndx, BigdataValueFactory valueFactory, boolean readOnly, boolean storeBlankNodes, int numTerms, BigdataValue[] terms, WriteTaskStats stats) {
        if (ndx == null) {
            throw new IllegalArgumentException();
        }
        if (valueFactory == null) {
            throw new IllegalArgumentException();
        }
        if (terms == null) {
            throw new IllegalArgumentException();
        }
        if (numTerms < 0 || numTerms > terms.length) {
            throw new IllegalArgumentException();
        }
        if (stats == null) {
            throw new IllegalArgumentException();
        }
        this.ndx = ndx;
        this.valueFactory = valueFactory;
        this.readOnly = readOnly;
        this.storeBlankNodes = storeBlankNodes;
        this.numTerms = numTerms;
        this.terms = terms;
        this.stats = stats;
    }

    @Override
    public KVO<BigdataValue>[] call() throws Exception {
        int ndistinct = 0;
        long _begin = System.currentTimeMillis();
        Object[] b = new BlobsIndexHelper().generateKVOs(this.valueFactory.getValueSerializer(), this.terms, this.numTerms);
        this.stats.keyGenTime.add(System.currentTimeMillis() - _begin);
        _begin = System.currentTimeMillis();
        Arrays.sort(b);
        this.stats.keySortTime.add(System.currentTimeMillis() - _begin);
        _begin = System.currentTimeMillis();
        byte[][] keys = new byte[this.numTerms][];
        byte[][] vals = new byte[this.numTerms][];
        KVO[] a = new KVO[this.numTerms];
        for (int i = 0; i < this.numTerms; ++i) {
            if (((BigdataValue)((KVO)b[i]).obj).getIV() != null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("IV already assigned: " + ((KVO)b[i]).obj));
                continue;
            }
            if (i > 0 && ((KVO)b[i - 1]).obj == ((KVO)b[i]).obj) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("duplicate reference: " + ((KVO)b[i]).obj));
                continue;
            }
            a[ndistinct] = b[i];
            keys[ndistinct] = ((KVO)b[i]).key;
            vals[ndistinct] = ((KVO)b[i]).val;
            ++ndistinct;
        }
        if (ndistinct == 0) {
            return new KVO[0];
        }
        BlobsWriteProc.BlobsWriteProcConstructor ctor = new BlobsWriteProc.BlobsWriteProcConstructor(this.readOnly, this.storeBlankNodes);
        this.ndx.submit(0, ndistinct, keys, vals, ctor, new BlobsWriteProcResultHandler(a, this.readOnly, this.stats));
        this.stats.termsIndexTime = System.currentTimeMillis() - _begin;
        this.stats.indexTime.addAndGet(this.stats.termsIndexTime);
        this.stats.ndistinct.addAndGet(ndistinct);
        return KVO.dense(a, ndistinct);
    }

    static class BlobsWriteProcResultHandler
    implements IResultHandler<BlobsWriteProc.Result, Void> {
        private final KVO<BigdataValue>[] a;
        private final boolean readOnly;
        private final WriteTaskStats stats;

        public BlobsWriteProcResultHandler(KVO<BigdataValue>[] a, boolean readOnly, WriteTaskStats stats) {
            if (a == null) {
                throw new IllegalArgumentException();
            }
            if (stats == null) {
                throw new IllegalArgumentException();
            }
            this.a = a;
            this.readOnly = readOnly;
            this.stats = stats;
        }

        @Override
        public void aggregate(BlobsWriteProc.Result result, Split split) {
            int tmp;
            this.stats.totalBucketSize.add(result.totalBucketSize);
            while ((tmp = this.stats.maxBucketSize.get()) < result.maxBucketSize && !this.stats.maxBucketSize.compareAndSet(tmp, result.maxBucketSize)) {
            }
            int i = split.fromIndex;
            int j = 0;
            while (i < split.toIndex) {
                int counter = result.counters[j];
                if (counter == Integer.MIN_VALUE) {
                    if (!this.readOnly) {
                        throw new AssertionError();
                    }
                    this.stats.nunknown.incrementAndGet();
                } else {
                    KVOList tmp2;
                    BigdataValue value = (BigdataValue)this.a[i].obj;
                    BlobIV iv = new BlobIV(VTE.valueOf(value), value.hashCode(), (short)counter);
                    value.setIV(iv);
                    if (this.a[i] instanceof KVOList && !(tmp2 = (KVOList)this.a[i]).isDuplicateListEmpty()) {
                        tmp2.map(new AssignTermId(iv));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("termId=" + iv + ", term=" + this.a[i].obj));
                    }
                }
                ++i;
                ++j;
            }
        }

        @Override
        public Void getResult() {
            return null;
        }
    }
}

