/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import java.math.BigInteger;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Value;

public class XsdUnsignedLongBOp
extends IVValueExpression<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = -8564789336767221003L;
    private static final transient Logger log = Logger.getLogger(XsdUnsignedLongBOp.class);
    private static BigInteger MIN_UNSIGNED_LONG = new BigInteger("0");
    private static BigInteger MAX_UNSIGNED_LONG = new BigInteger("18446744073709551615");

    public XsdUnsignedLongBOp(IValueExpression<? extends IV> x, GlobalAnnotations globals) {
        this(new BOp[]{x}, XsdUnsignedLongBOp.anns(globals, new NV[0]));
    }

    public XsdUnsignedLongBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 1 || args[0] == null) {
            throw new IllegalArgumentException();
        }
        if (this.getProperty(IVValueExpression.Annotations.NAMESPACE) == null) {
            throw new IllegalArgumentException();
        }
    }

    public XsdUnsignedLongBOp(XsdUnsignedLongBOp op) {
        super(op);
    }

    public IV get(IBindingSet bs) {
        IV iv = this.getAndCheckBound(0, bs);
        if (log.isDebugEnabled()) {
            log.debug((Object)iv);
        }
        Value val = XsdUnsignedLongBOp.asValue(iv);
        if (log.isDebugEnabled()) {
            log.debug((Object)val);
        }
        BigdataValueFactory vf = this.getValueFactory();
        try {
            if (val instanceof Literal) {
                Literal lit = (Literal)val;
                if (lit.getDatatype() != null && lit.getDatatype().equals((Object)XSD.UNSIGNED_LONG)) {
                    return iv;
                }
                BigInteger valAsBigInt = new BigInteger(lit.getLabel());
                if (valAsBigInt.compareTo(MIN_UNSIGNED_LONG) >= 0 && valAsBigInt.compareTo(MAX_UNSIGNED_LONG) <= 0) {
                    BigdataLiteral str = vf.createLiteral(String.valueOf(valAsBigInt.toString()), XSD.UNSIGNED_LONG);
                    return super.asIV(str, bs);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        throw new SparqlTypeErrorException();
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.SOMETIMES;
    }
}

