/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.NotMaterializedException;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.XSDBooleanIVValueExpression;
import java.util.Map;
import org.openrdf.model.Literal;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class LangMatchesBOp
extends XSDBooleanIVValueExpression
implements INeedsMaterialization {
    private static final long serialVersionUID = 5910711647357240974L;

    public LangMatchesBOp(IValueExpression<? extends IV> tag, IValueExpression<? extends IV> range) {
        this(new BOp[]{tag, range}, BOp.NOANNS);
    }

    public LangMatchesBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 2 || args[0] == null || args[1] == null) {
            throw new IllegalArgumentException();
        }
    }

    public LangMatchesBOp(LangMatchesBOp op) {
        super(op);
    }

    @Override
    protected boolean accept(IBindingSet bs) {
        IV tag = (IV)this.get(0).get(bs);
        if (tag == null) {
            throw new SparqlTypeErrorException();
        }
        IV range = (IV)this.get(1).get(bs);
        if (range == null) {
            throw new SparqlTypeErrorException();
        }
        Object tagVal = tag.getValue();
        if (tagVal == null) {
            throw new NotMaterializedException();
        }
        if (!QueryEvaluationUtil.isSimpleLiteral(tagVal)) {
            throw new SparqlTypeErrorException();
        }
        Object rangeVal = range.getValue();
        if (rangeVal == null) {
            throw new NotMaterializedException();
        }
        if (!QueryEvaluationUtil.isSimpleLiteral(rangeVal)) {
            throw new SparqlTypeErrorException();
        }
        String langTag = ((Literal)tagVal).getLabel();
        String langRange = ((Literal)rangeVal).getLabel();
        boolean result = false;
        if (langRange.equals("*")) {
            result = langTag.length() > 0;
        } else if (langTag.length() == langRange.length()) {
            result = langTag.equalsIgnoreCase(langRange);
        } else if (langTag.length() > langRange.length()) {
            String prefix = langTag.substring(0, langRange.length());
            result = prefix.equalsIgnoreCase(langRange) && langTag.charAt(langRange.length()) == '-';
        }
        return result;
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.ALWAYS;
    }
}

