/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.inf;

import com.bigdata.rdf.inf.BackchainOwlSameAsIterator;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.TempTripleStore;
import com.bigdata.striterator.EmptyChunkedIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import java.util.Arrays;
import java.util.Set;

public class BackchainOwlSameAsPropertiesPIterator
extends BackchainOwlSameAsIterator {
    private IChunkedOrderedIterator<ISPO> sameAs2and3It;
    private TempTripleStore sameAs2and3;
    private boolean canRemove = false;

    public BackchainOwlSameAsPropertiesPIterator(IChunkedOrderedIterator<ISPO> src, IV p, AbstractTripleStore db, IV sameAs) {
        super(src, db, sameAs);
    }

    @Override
    public IKeyOrder<ISPO> getKeyOrder() {
        return this.src.getKeyOrder();
    }

    public boolean hasNext() {
        if (this.src.hasNext()) {
            return true;
        }
        if (this.sameAs2and3It == null) {
            this.sameAs2and3It = this.sameAs2and3 != null ? this.sameAs2and3.getAccessPath(SPOKeyOrder.SPO).iterator() : new EmptyChunkedIterator<ISPO>(SPOKeyOrder.SPO);
        }
        return this.sameAs2and3It.hasNext();
    }

    @Override
    public ISPO next() {
        this.canRemove = false;
        ISPO current = null;
        if (this.src.hasNext()) {
            current = (ISPO)this.src.next();
            this.processSameAs2and3(current);
            this.canRemove = true;
        } else {
            if (this.sameAs2and3It == null) {
                this.sameAs2and3It = this.sameAs2and3 != null ? this.sameAs2and3.getAccessPath(SPOKeyOrder.SPO).iterator() : new EmptyChunkedIterator<ISPO>(SPOKeyOrder.SPO);
            }
            if (this.sameAs2and3It.hasNext()) {
                current = (ISPO)this.sameAs2and3It.next();
            }
        }
        return current;
    }

    private void processSameAs2and3(ISPO spo) {
        boolean present;
        IChunkedOrderedIterator<ISPO> absent;
        ISPO[] spos = new SPO[100];
        int numSPOs = 0;
        Set<IV> sAndSames = this.getSelfAndSames(spo.s());
        Set<IV> oAndSames = this.getSelfAndSames(spo.o());
        if (sAndSames.size() == 1 && oAndSames.size() == 1) {
            return;
        }
        for (IV s1 : sAndSames) {
            for (IV o1 : oAndSames) {
                if (IVUtility.equals(spo.p(), this.sameAs) && IVUtility.equals(s1, o1)) continue;
                if (numSPOs == 100) {
                    boolean present2 = false;
                    IChunkedOrderedIterator<ISPO> absent2 = this.db.bulkFilterStatements(spos, numSPOs, present2);
                    if (absent2.hasNext()) {
                        if (this.sameAs2and3 == null) {
                            this.sameAs2and3 = this.createTempTripleStore();
                        }
                        this.db.addStatements(this.sameAs2and3, true, absent2, null);
                    }
                    numSPOs = 0;
                }
                spos[numSPOs++] = new SPO(s1, spo.p(), o1, StatementEnum.Inferred);
                this.dumpSPO(spos[numSPOs - 1]);
            }
        }
        if (numSPOs > 0 && (absent = this.db.bulkFilterStatements(spos, numSPOs, present = false)).hasNext()) {
            if (this.sameAs2and3 == null) {
                this.sameAs2and3 = this.createTempTripleStore();
            }
            this.db.addStatements(this.sameAs2and3, true, absent, null);
        }
    }

    public ISPO[] nextChunk() {
        ISPO[] s = new ISPO[100];
        int n = 0;
        while (this.hasNext() && n < 100) {
            s[n++] = this.next();
        }
        ISPO[] stmts = new ISPO[n];
        System.arraycopy(s, 0, stmts, 0, n);
        return stmts;
    }

    public ISPO[] nextChunk(IKeyOrder<ISPO> keyOrder) {
        if (keyOrder == null) {
            throw new IllegalArgumentException();
        }
        ISPO[] stmts = this.nextChunk();
        if (this.src.getKeyOrder() != keyOrder) {
            Arrays.sort(stmts, 0, stmts.length, keyOrder.getComparator());
        }
        return stmts;
    }

    public void close() {
        this.src.close();
        if (this.sameAs2and3It != null) {
            this.sameAs2and3It.close();
        }
        if (this.sameAs2and3 != null) {
            this.sameAs2and3.close();
        }
    }

    @Override
    public void remove() {
        if (this.canRemove) {
            this.src.remove();
        }
    }
}

