/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.changesets;

import com.bigdata.rdf.changesets.ChangeAction;
import com.bigdata.rdf.changesets.IChangeRecord;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPOComparator;
import java.util.Comparator;

public class ChangeRecord
implements IChangeRecord {
    private final ISPO stmt;
    private final ChangeAction action;
    public static final Comparator<IChangeRecord> COMPARATOR = new Comparator<IChangeRecord>(){

        @Override
        public int compare(IChangeRecord r1, IChangeRecord r2) {
            ISPO spo1 = r1.getStatement();
            ISPO spo2 = r2.getStatement();
            return SPOComparator.INSTANCE.compare(spo1, spo2);
        }
    };

    public ChangeRecord(ISPO stmt, ChangeAction action) {
        this.stmt = stmt;
        this.action = action;
    }

    @Override
    public ChangeAction getChangeAction() {
        return this.action;
    }

    @Override
    public ISPO getStatement() {
        return this.stmt;
    }

    public int hashCode() {
        return this.stmt.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof IChangeRecord)) {
            return false;
        }
        IChangeRecord rec = (IChangeRecord)o;
        ISPO stmt2 = rec.getStatement();
        if (this.stmt == stmt2 || this.stmt != null && stmt2 != null && this.stmt.equals(stmt2)) {
            return this.action == rec.getChangeAction();
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.action).append(": ").append(this.stmt);
        return sb.toString();
    }
}

