/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.journal.ICommitRecord;

public class CommitRecord
implements ICommitRecord {
    private final long timestamp;
    private final long commitCounter;
    private final long[] roots;

    public CommitRecord() {
        this(0L, 0L, new long[50]);
    }

    public CommitRecord(long timestamp, long commitCounter, long[] roots) {
        assert (roots != null);
        assert (roots.length == 50) : "roots.length=" + roots.length + ", but expecting: " + 50;
        this.timestamp = timestamp;
        this.commitCounter = commitCounter;
        this.roots = roots;
    }

    @Override
    public final long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public final long getCommitCounter() {
        return this.commitCounter;
    }

    @Override
    public final int getRootAddrCount() {
        return this.roots.length;
    }

    @Override
    public final long getRootAddr(int index) {
        return this.roots[index];
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CommitRecord");
        sb.append("{timestamp=" + this.timestamp);
        sb.append(", commitCounter=" + this.commitCounter);
        sb.append(", roots=[");
        for (int i = 0; i < this.roots.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.roots[i]);
        }
        sb.append("]}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ICommitRecord)) {
            return false;
        }
        ICommitRecord t = (ICommitRecord)o;
        if (this.timestamp != t.getTimestamp()) {
            return false;
        }
        if (this.commitCounter != t.getCommitCounter()) {
            return false;
        }
        if (this.roots.length != t.getRootAddrCount()) {
            return false;
        }
        for (int i = 0; i < this.roots.length; ++i) {
            if (this.roots[i] == t.getRootAddr(i)) continue;
            return false;
        }
        return true;
    }
}

