/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io;

import java.io.File;
import java.io.FileFilter;

public class NameAndExtensionFilter
implements FileFilter {
    private final String basename;
    private final String ext;
    private static final File[] EMPTY_ARRAY = new File[0];

    public NameAndExtensionFilter(String basename, String ext) {
        if (basename == null) {
            throw new IllegalArgumentException();
        }
        if (ext == null) {
            throw new IllegalArgumentException();
        }
        this.basename = basename;
        this.ext = ext;
    }

    public String getBaseName() {
        return this.basename;
    }

    @Override
    public boolean accept(File pathname) {
        String expectedName = new File(this.basename).getName();
        String actualName = pathname.getName();
        return (this.ext.length() == 0 || actualName.endsWith(this.ext)) && actualName.startsWith(expectedName);
    }

    public File[] getFiles() {
        File file = new File(this.basename).getAbsoluteFile();
        File dir = file.isDirectory() ? file : file.getParentFile();
        File[] files = dir.listFiles(this);
        if (files == null) {
            return EMPTY_ARRAY;
        }
        return files;
    }
}

