/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io;

import com.bigdata.io.IByteArraySlice;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.zip.Adler32;

public class ChecksumUtility {
    public static final ThreadLocal<ChecksumUtility> threadChk = new ThreadLocal<ChecksumUtility>(){

        @Override
        protected ChecksumUtility initialValue() {
            return new ChecksumUtility();
        }
    };
    protected final Adler32 chk = new Adler32();
    private volatile byte[] a;

    public static ChecksumUtility getCHK() {
        return threadChk.get();
    }

    public int checksum(ByteBuffer buf) {
        return this.checksum(buf, buf.position(), buf.limit());
    }

    public int checksum(ByteBuffer buf, int pos, int limit) {
        assert (buf != null);
        assert (pos >= 0);
        assert (limit > pos);
        this.chk.reset();
        this.update(buf, pos, limit);
        return (int)this.chk.getValue();
    }

    protected void reset() {
        this.chk.reset();
    }

    protected int getChecksum() {
        return (int)this.chk.getValue();
    }

    protected void update(ByteBuffer buf) {
        this.update(buf, buf.position(), buf.limit());
    }

    protected void update(ByteBuffer buf, int pos, int limit) {
        assert (buf != null);
        assert (pos >= 0);
        assert (limit > pos);
        if (buf.hasArray()) {
            int len;
            byte[] bytes = buf.array();
            if (pos > bytes.length - (len = limit - pos)) {
                throw new BufferUnderflowException();
            }
            this.chk.update(bytes, pos + buf.arrayOffset(), len);
        } else {
            if (this.a == null) {
                this.a = new byte[512];
            }
            ByteBuffer b = buf.asReadOnlyBuffer();
            int m = limit;
            for (int p = pos; p < m; p += this.a.length) {
                int len = Math.min(m - p, this.a.length);
                b.limit(p + len);
                b.position(p);
                b.get(this.a, 0, len);
                this.chk.update(this.a, 0, len);
            }
        }
    }

    public int checksum(IByteArraySlice slice) {
        assert (slice != null);
        this.chk.reset();
        this.chk.update(slice.array(), slice.off(), slice.len());
        return (int)this.chk.getValue();
    }

    public int checksum(byte[] buf) {
        return this.checksum(buf, 0, buf.length);
    }

    public int checksum(byte[] buf, int sze) {
        return this.checksum(buf, 0, sze);
    }

    public int checksum(byte[] buf, int off, int sze) {
        assert (buf != null);
        this.chk.reset();
        this.chk.update(buf, off, sze);
        return (int)this.chk.getValue();
    }
}

