/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ha.pipeline;

import com.bigdata.ha.msg.HASendState;
import com.bigdata.ha.pipeline.AbstractPipelineException;
import com.bigdata.ha.pipeline.ImmediateDownstreamReplicationException;
import com.bigdata.ha.pipeline.NestedPipelineException;
import com.bigdata.util.InnerCause;
import com.bigdata.util.concurrent.Haltable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public class HASendService {
    private static final Logger log = Logger.getLogger(HASendService.class);
    private final AtomicReference<InetSocketAddress> addrNext = new AtomicReference();
    private final AtomicReference<ExecutorService> executorRef = new AtomicReference();
    private final AtomicReference<SocketChannel> socketChannel = new AtomicReference();
    private final boolean blocking;
    private static final long[] retryMillis = new long[]{1L, 5L, 10L, 50L, 100L, 250L, 250L, 250L, 250L};

    public String toString() {
        return super.toString() + "{addrNext=" + this.addrNext + "}";
    }

    public InetSocketAddress getAddrNext() {
        return this.addrNext.get();
    }

    public HASendService() {
        this(true);
    }

    private HASendService(boolean blocking) {
        this.blocking = blocking;
    }

    protected void finalize() throws Throwable {
        this.terminate();
        super.finalize();
    }

    boolean isRunning() {
        return this.executorRef.get() != null;
    }

    public synchronized void start(InetSocketAddress addrNext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.toString() + " : starting."));
        }
        if (addrNext == null) {
            throw new IllegalArgumentException();
        }
        if (this.executorRef.get() != null) {
            log.error((Object)"Already running.");
            throw new IllegalStateException("Already running.");
        }
        this.addrNext.set(addrNext);
        this.socketChannel.set(null);
        this.executorRef.set(Executors.newSingleThreadExecutor());
        if (log.isInfoEnabled()) {
            log.info((Object)(this.toString() + " : running."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void terminate() {
        ExecutorService tmp;
        if (log.isInfoEnabled()) {
            log.info((Object)(this.toString() + " : stopping."));
        }
        if ((tmp = (ExecutorService)this.executorRef.getAndSet(null)) == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Service was not running.");
            }
            return;
        }
        try {
            this.closeSocketChannelNoBlock();
        }
        finally {
            tmp.shutdownNow();
            this.addrNext.set(null);
            if (log.isInfoEnabled()) {
                log.info((Object)(this.toString() + " : stopped."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocketChannelNoBlock() {
        SocketChannel socketChannel = this.socketChannel.get();
        if (socketChannel != null) {
            try {
                socketChannel.close();
            }
            catch (IOException ex) {
                log.error((Object)("Ignoring exception during close: " + ex), (Throwable)ex);
            }
            finally {
                this.socketChannel.set(null);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"Closed socket channel");
            }
        }
    }

    public Future<Void> send(ByteBuffer buffer, byte[] marker) throws ImmediateDownstreamReplicationException, InterruptedException {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        if (buffer.remaining() == 0) {
            throw new IllegalArgumentException();
        }
        ExecutorService tmp = this.executorRef.get();
        if (tmp == null) {
            throw new IllegalStateException("Service is not running.");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Will send " + buffer.remaining() + " bytes"));
        }
        try {
            return tmp.submit(this.newIncSendTask(buffer.asReadOnlyBuffer(), marker));
        }
        catch (Throwable t) {
            this.launderThrowable(t);
            throw new AssertionError();
        }
    }

    private void launderThrowable(Throwable t) throws InterruptedException, ImmediateDownstreamReplicationException {
        if (Haltable.isTerminationByInterrupt(t)) {
            throw new RuntimeException(t);
        }
        if (InnerCause.isInnerCause((Throwable)t, AbstractPipelineException.class)) {
            throw new NestedPipelineException(t);
        }
        throw new ImmediateDownstreamReplicationException(this.toString(), t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketChannel reopenChannel() {
        AtomicReference<SocketChannel> atomicReference = this.socketChannel;
        synchronized (atomicReference) {
            int tryno = 0;
            SocketChannel sc = null;
            while (((sc = this.socketChannel.get()) == null || !sc.isOpen()) && this.isRunning()) {
                try {
                    sc = this.openChannel(this.addrNext.get());
                    this.socketChannel.set(sc);
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Opened channel on try: " + tryno + ", addrNext=" + this.addrNext));
                }
                catch (IOException e) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Failed to open channel on try: " + tryno + ", addrNext=" + this.addrNext));
                    }
                    if (tryno < retryMillis.length) {
                        try {
                            Thread.sleep(retryMillis[tryno]);
                            ++tryno;
                            continue;
                        }
                        catch (InterruptedException e1) {
                            throw new RuntimeException(e);
                        }
                    }
                    throw new RuntimeException(e);
                }
            }
            return this.socketChannel.get();
        }
    }

    protected Callable<Void> newIncSendTask(ByteBuffer buffer, byte[] marker) {
        return new IncSendTask(buffer, marker);
    }

    private SocketChannel openChannel(InetSocketAddress addr) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        try {
            socketChannel.configureBlocking(this.blocking);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Connecting to " + addr));
            }
            if (!socketChannel.connect(addr)) {
                while (!socketChannel.finishConnect()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        catch (IOException ex) {
            log.error((Object)ex);
            throw ex;
        }
        return socketChannel;
    }

    protected class IncSendTask
    implements Callable<Void> {
        private final ByteBuffer data;
        private final byte[] marker;

        public IncSendTask(ByteBuffer data, byte[] marker) {
            if (data == null) {
                throw new IllegalArgumentException();
            }
            this.data = data;
            this.marker = marker;
        }

        @Override
        public Void call() throws Exception {
            try {
                return this.doInnerCall();
            }
            catch (Throwable t) {
                SocketChannel sc = (SocketChannel)HASendService.this.socketChannel.get();
                log.error((Object)("socketChannel=" + sc + (sc == null ? "" : ", sc.isOpen()=" + sc.isOpen() + ", sc.isConnected()=" + sc.isConnected()) + ", marker=" + HASendState.decode(this.marker) + ", cause=" + t), t);
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Void doInnerCall() throws Exception {
            ByteBuffer markerBB;
            SocketChannel socketChannel = HASendService.this.reopenChannel();
            if (!HASendService.this.isRunning()) {
                throw new RuntimeException("Not Running.");
            }
            if (socketChannel == null) {
                throw new AssertionError();
            }
            int remaining = this.data.remaining();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Will send " + remaining + " bytes"));
            }
            int nmarker = 0;
            int nwritten = 0;
            ByteBuffer byteBuffer = markerBB = this.marker != null ? ByteBuffer.wrap(this.marker) : null;
            while (nwritten < remaining) {
                int nbytes;
                if (this.marker != null && nmarker < this.marker.length) {
                    nmarker += socketChannel.write(markerBB);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    int limit = this.data.limit();
                    if (this.data.position() < limit - 50000) {
                        this.data.limit(this.data.position() + 50000);
                    }
                    nbytes = socketChannel.write(this.data);
                    this.data.limit(limit);
                    log.debug((Object)("Written " + (nwritten += nbytes) + " of total " + this.data.limit()));
                    if (nwritten < limit) {
                        Thread.sleep(1L);
                    }
                } else {
                    nbytes = socketChannel.write(this.data);
                    nwritten += nbytes;
                }
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Sent " + nbytes + " bytes with " + nwritten + " of out " + remaining + " written so far"));
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Sent total of " + remaining + " bytes"));
            }
            if (this.data.remaining() != 0) {
                throw new IOException("Did not write all data: expected=" + remaining + ", actual=" + this.data.remaining());
            }
            return null;
        }
    }
}

