/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ha.halog;

import com.bigdata.ha.halog.HALogReader;
import com.bigdata.ha.halog.IHALogReader;
import com.bigdata.ha.halog.IHALogWriter;
import com.bigdata.ha.msg.IHAWriteMessage;
import com.bigdata.io.FileChannelUtility;
import com.bigdata.io.IReopenChannel;
import com.bigdata.io.SerializerUtil;
import com.bigdata.journal.CommitCounterUtility;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.RootBlockUtility;
import com.bigdata.journal.StoreTypeEnum;
import com.bigdata.util.StackInfoReport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.DigestException;
import java.security.MessageDigest;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public class HALogWriter
implements IHALogWriter {
    private static final Logger haLog = Logger.getLogger((String)"com.bigdata.haLog");
    static final int SIZE_MAGIC = 4;
    static final int SIZE_VERSION = 4;
    static final int SIZEOF_ROOT_BLOCK = 340;
    static final int OFFSET_ROOT_BLOCK0 = 8;
    static final int OFFSET_ROOT_BLOCK1 = 348;
    static final int headerSize0 = 688;
    public static final int MAGIC = -2082883787;
    public static final int VERSION1 = 1;
    private final File m_haLogDir;
    private final boolean doubleSync;
    private IRootBlockView m_rootBlock;
    private long m_nextSequence = 0L;
    private FileState m_state = null;
    private final ReentrantReadWriteLock m_stateLock = new ReentrantReadWriteLock();
    private long m_position = 688L;
    private final IReopenChannel<FileChannel> reopener = new IReopenChannel<FileChannel>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileChannel reopenChannel() throws IOException {
            ReentrantReadWriteLock.ReadLock lock = HALogWriter.this.m_stateLock.readLock();
            lock.lock();
            try {
                if (HALogWriter.this.m_state == null || HALogWriter.this.m_state.m_channel == null || !HALogWriter.this.m_state.m_channel.isOpen()) {
                    throw new IOException("Closed");
                }
                FileChannel fileChannel = HALogWriter.this.m_state.m_channel;
                return fileChannel;
            }
            finally {
                lock.unlock();
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCommitCounter() {
        ReentrantReadWriteLock.ReadLock lock = this.m_stateLock.readLock();
        lock.lock();
        try {
            this.assertOpen();
            long l = this.m_rootBlock.getCommitCounter();
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSequence() {
        ReentrantReadWriteLock.ReadLock lock = this.m_stateLock.readLock();
        lock.lock();
        try {
            this.assertOpen();
            long l = this.m_nextSequence;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    private void assertOpen() {
        if (this.m_state == null) {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isHALogOpen() {
        ReentrantReadWriteLock.ReadLock lock = this.m_stateLock.readLock();
        lock.lock();
        try {
            boolean bl = this.m_state != null && !this.m_state.isCommitted();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFile() {
        ReentrantReadWriteLock.ReadLock lock = this.m_stateLock.readLock();
        lock.lock();
        try {
            File file = this.m_state == null ? null : this.m_state.m_haLogFile;
            return file;
        }
        finally {
            lock.unlock();
        }
    }

    public static File getHALogFileName(File dir, long commitCounter) {
        return CommitCounterUtility.getCommitCounterFile(dir, commitCounter, ".ha-log");
    }

    public String toString() {
        IRootBlockView tmp = this.m_rootBlock;
        long seq = this.m_nextSequence;
        return this.getClass().getName() + "{" + this.m_state == null ? "closed" : "commitCounter=" + tmp.getCommitCounter() + ",nextSequence=" + seq + "}";
    }

    public HALogWriter(File logDir, boolean doubleSync) {
        this.m_haLogDir = logDir;
        this.doubleSync = doubleSync;
    }

    HALogWriter(File logDir) {
        this(logDir, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLog(IRootBlockView rootBlock) throws FileNotFoundException, IOException {
        if (rootBlock == null) {
            throw new IllegalArgumentException();
        }
        if (this.m_rootBlock != null) {
            throw new IllegalStateException();
        }
        if (haLog.isInfoEnabled()) {
            haLog.info((Object)("rootBlock=" + rootBlock), (Throwable)new StackInfoReport());
        }
        this.m_rootBlock = rootBlock;
        this.m_nextSequence = 0L;
        long commitCounter = rootBlock.getCommitCounter();
        File log = HALogWriter.getHALogFileName(this.m_haLogDir, commitCounter + 1L);
        if (log.exists() && !log.delete()) {
            throw new IOException("Could not delete: " + log);
        }
        File parentDir = log.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("Could not create directory: " + parentDir);
        }
        ReentrantReadWriteLock.WriteLock lock = this.m_stateLock.writeLock();
        lock.lock();
        try {
            this.m_state = new FileState(log, rootBlock.getStoreType());
            this.m_state.m_raf.seek(0L);
            this.m_state.m_raf.writeInt(-2082883787);
            this.m_state.m_raf.writeInt(1);
            this.writeRootBlock(true, rootBlock);
            this.writeRootBlock(false, rootBlock);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeHALog(IRootBlockView rootBlock) throws FileNotFoundException, IOException {
        ReentrantReadWriteLock.WriteLock lock = this.m_stateLock.writeLock();
        lock.lock();
        try {
            long expectedCommitCounter;
            if (rootBlock == null) {
                throw new IllegalArgumentException();
            }
            if (this.m_rootBlock == null) {
                throw new IllegalStateException();
            }
            if (haLog.isInfoEnabled()) {
                haLog.info((Object)("rootBlock=" + rootBlock));
            }
            if ((expectedCommitCounter = this.m_rootBlock.getCommitCounter() + 1L) != rootBlock.getCommitCounter()) {
                throw new IllegalStateException("CommitCounter: expected=" + expectedCommitCounter + ", actual=" + rootBlock.getCommitCounter());
            }
            if (!this.m_rootBlock.getUUID().equals(rootBlock.getUUID())) {
                throw new IllegalStateException("Store UUID: expected=" + this.m_rootBlock.getUUID() + ", actual=" + rootBlock.getUUID());
            }
            if (this.doubleSync) {
                this.flush();
            }
            this.writeRootBlock(rootBlock.isRootBlock0(), rootBlock);
            this.flush();
            this.m_state.committed();
            this.close();
        }
        finally {
            lock.unlock();
        }
    }

    private void writeRootBlock(boolean isRootBlock0, IRootBlockView rootBlock) throws IOException {
        if (rootBlock == null) {
            throw new IllegalArgumentException();
        }
        long position = isRootBlock0 ? 8L : 348L;
        FileChannelUtility.writeAll(this.reopener, rootBlock.asReadOnlyBuffer(), position);
        if (haLog.isDebugEnabled()) {
            haLog.debug((Object)("wrote root block: " + rootBlock));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeOnHALog(IHAWriteMessage msg, ByteBuffer data) throws IOException, IllegalStateException {
        ReentrantReadWriteLock.ReadLock lock = this.m_stateLock.readLock();
        lock.lock();
        try {
            this.assertOpen();
            if (this.m_rootBlock.getCommitCounter() != msg.getCommitCounter()) {
                throw new IllegalStateException("commitCounter=" + this.m_rootBlock.getCommitCounter() + ", but msg=" + msg);
            }
            if (this.m_rootBlock.getLastCommitTime() != msg.getLastCommitTime()) {
                throw new IllegalStateException("lastCommitTime=" + this.m_rootBlock.getLastCommitTime() + ", but msg=" + msg);
            }
            if (this.m_nextSequence != msg.getSequence()) {
                throw new IllegalStateException("nextSequence=" + this.m_nextSequence + ", but msg=" + msg);
            }
            if (haLog.isDebugEnabled()) {
                haLog.debug((Object)("msg=" + msg + ", position=" + this.m_position));
            }
            if (this.m_position < 688L) {
                throw new AssertionError((Object)("position=" + this.m_position + ", but headerSize=" + 688));
            }
            ByteBuffer tmp = this.bufferObject(msg);
            int nbytes = tmp.limit();
            FileChannelUtility.writeAll(this.reopener, tmp, this.m_position);
            this.m_position += (long)nbytes;
            ++this.m_nextSequence;
            switch (this.m_rootBlock.getStoreType()) {
                case WORM: 
                case RW: {
                    int nbytes2 = msg.getSize();
                    assert (data.position() == 0);
                    assert (data.limit() == nbytes2);
                    FileChannelUtility.writeAll(this.reopener, data.duplicate(), this.m_position);
                    this.m_position += (long)nbytes2;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.m_state.addRecord();
        }
        finally {
            lock.unlock();
        }
    }

    private ByteBuffer bufferObject(Object obj) throws IOException {
        return ByteBuffer.wrap(SerializerUtil.serialize(obj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() throws IOException {
        try {
            if (this.m_state != null) {
                this.m_state.close();
            }
        }
        finally {
            this.reset();
        }
    }

    private void reset() {
        assert (this.m_stateLock.isWriteLocked());
        this.m_state = null;
        this.m_position = 688L;
        this.m_rootBlock = null;
        this.m_nextSequence = 0L;
    }

    private void flush() throws IOException {
        if (this.m_state != null) {
            this.m_state.m_channel.force(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove() throws IOException {
        ReentrantReadWriteLock.WriteLock lock = this.m_stateLock.writeLock();
        lock.lock();
        try {
            if (this.m_state != null) {
                boolean isCommitted = this.m_state.isCommitted();
                if (haLog.isInfoEnabled()) {
                    haLog.info((Object)("Will close: " + this.m_state.m_haLogFile + ", committed: " + isCommitted));
                }
                this.m_state.forceCloseAll();
                if (isCommitted) {
                    return;
                }
                if (haLog.isInfoEnabled()) {
                    haLog.info((Object)("Will remove: " + this.m_state.m_haLogFile), (Throwable)new StackInfoReport());
                }
                if (this.m_state.m_haLogFile.exists() && !this.m_state.m_haLogFile.delete()) {
                    throw new IOException("Could not delete: " + this.m_state.m_haLogFile);
                }
            }
        }
        finally {
            this.reset();
            lock.unlock();
        }
    }

    @Override
    public void disableHALog() throws IOException {
        if (haLog.isInfoEnabled()) {
            haLog.info((Object)"");
        }
        this.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHALogReader getReader(long commitCounter) throws FileNotFoundException, IOException {
        File logFile = HALogWriter.getHALogFileName(this.m_haLogDir, commitCounter);
        ReentrantReadWriteLock.ReadLock lock = this.m_stateLock.readLock();
        lock.lock();
        try {
            if (!logFile.exists()) {
                throw new FileNotFoundException(logFile.getName());
            }
            if (this.m_state != null && this.m_rootBlock.getCommitCounter() + 1L == commitCounter) {
                if (haLog.isDebugEnabled()) {
                    haLog.debug((Object)("Opening live HALog: file=" + this.m_state.m_haLogFile));
                }
                OpenHALogReader openHALogReader = new OpenHALogReader(this.m_state);
                return openHALogReader;
            }
            if (haLog.isDebugEnabled()) {
                haLog.debug((Object)("Opening historical HALog: file=" + logFile));
            }
            HALogReader hALogReader = new HALogReader(logFile);
            return hALogReader;
        }
        finally {
            lock.unlock();
        }
    }

    static class OpenHALogReader
    implements IHALogReader {
        private final FileState m_state;
        private long m_record = 0L;
        private long m_position = 688L;
        private final AtomicBoolean open = new AtomicBoolean(true);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OpenHALogReader(FileState state) {
            if (state == null) {
                throw new IllegalArgumentException();
            }
            FileState fileState = this.m_state = state;
            synchronized (fileState) {
                this.m_state.m_accessors++;
            }
        }

        @Override
        public boolean isLive() {
            return true;
        }

        @Override
        public IRootBlockView getOpeningRootBlock() throws IOException {
            RootBlockUtility tmp = new RootBlockUtility(this.m_state.reopener, this.m_state.m_haLogFile, true, false, false);
            IRootBlockView closeRootBlock = tmp.chooseRootBlock();
            IRootBlockView openRootBlock = tmp.rootBlock0 == closeRootBlock ? tmp.rootBlock1 : tmp.rootBlock0;
            return openRootBlock;
        }

        @Override
        public IRootBlockView getClosingRootBlock() throws IOException {
            RootBlockUtility tmp = new RootBlockUtility(this.m_state.reopener, this.m_state.m_haLogFile, true, false, false);
            return tmp.chooseRootBlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasMoreBuffers() {
            if (!this.isOpen()) {
                return false;
            }
            FileState fileState = this.m_state;
            synchronized (fileState) {
                if (!this.m_state.isOpen()) {
                    return false;
                }
                if (this.m_state.isCommitted() && this.m_state.recordCount() <= this.m_record) {
                    return false;
                }
                if (this.m_state.recordCount() > this.m_record) {
                    return true;
                }
                this.m_state.waitOnStateChange(this.m_record + 1L);
            }
            return this.hasMoreBuffers();
        }

        @Override
        public boolean isOpen() {
            return this.open.get();
        }

        @Override
        public boolean isEmpty() {
            return this.m_state.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IHAWriteMessage processNextBuffer(ByteBuffer clientBuffer) throws IOException {
            IHAWriteMessage msg;
            FileState fileState = this.m_state;
            synchronized (fileState) {
                long savePosition = this.m_state.m_channel.position();
                this.m_state.m_channel.position(this.m_position);
                msg = HALogReader.processNextBuffer(this.m_state.m_raf, this.m_state.reopener, this.m_state.m_storeType, clientBuffer);
                this.m_position = this.m_state.m_channel.position();
                this.m_state.m_channel.position(savePosition);
            }
            ++this.m_record;
            return msg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.open.compareAndSet(true, false)) {
                FileState fileState = this.m_state;
                synchronized (fileState) {
                    if (this.m_state.m_accessors == 0) {
                        return;
                    }
                    this.m_state.close();
                }
            }
        }

        @Override
        public void computeDigest(MessageDigest digest) throws DigestException, IOException {
            HALogReader.computeDigest(this.m_state.reopener, digest);
        }
    }

    private static class FileState {
        private final StoreTypeEnum m_storeType;
        private final File m_haLogFile;
        private final FileChannel m_channel;
        private final RandomAccessFile m_raf;
        private long m_records = 0L;
        private boolean m_committed = false;
        private int m_accessors;
        private final IReopenChannel<FileChannel> reopener = new IReopenChannel<FileChannel>(){

            @Override
            public FileChannel reopenChannel() throws IOException {
                if (FileState.this.m_channel == null) {
                    throw new IOException("Closed");
                }
                return FileState.this.m_channel;
            }
        };

        private FileState(File file, StoreTypeEnum storeType) throws FileNotFoundException {
            this.m_haLogFile = file;
            this.m_storeType = storeType;
            this.m_raf = new RandomAccessFile(this.m_haLogFile, "rw");
            this.m_channel = this.m_raf.getChannel();
            this.m_accessors = 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forceCloseAll() throws IOException {
            FileState fileState = this;
            synchronized (fileState) {
                if (this.m_accessors > 0) {
                    this.m_accessors = 1;
                }
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            FileState fileState = this;
            synchronized (fileState) {
                try {
                    if (this.m_accessors == 0) {
                        throw new IllegalStateException();
                    }
                    --this.m_accessors;
                    if (this.m_accessors == 0) {
                        if (haLog.isInfoEnabled()) {
                            haLog.info((Object)"Closing file", (Throwable)new StackInfoReport());
                        }
                        this.m_raf.close();
                    }
                }
                finally {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRecord() {
            FileState fileState = this;
            synchronized (fileState) {
                ++this.m_records;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long recordCount() {
            FileState fileState = this;
            synchronized (fileState) {
                return this.m_records;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void committed() {
            FileState fileState = this;
            synchronized (fileState) {
                this.m_committed = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCommitted() {
            FileState fileState = this;
            synchronized (fileState) {
                return this.m_committed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            FileState fileState = this;
            synchronized (fileState) {
                return this.m_committed && this.m_records == 0L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isOpen() {
            FileState fileState = this;
            synchronized (fileState) {
                return this.m_accessors != 0 && this.m_raf.getChannel().isOpen();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitOnStateChange(long record) {
            FileState fileState = this;
            synchronized (fileState) {
                while (this.m_records < record && !this.m_committed) {
                    if (!this.isOpen()) {
                        return;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
        }
    }
}

