/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters;

import com.bigdata.counters.History;
import com.bigdata.counters.HistoryInstrument;
import com.bigdata.counters.ICounterSet;
import com.bigdata.counters.IInstrument;
import com.bigdata.counters.Instrument;
import com.bigdata.counters.PeriodEnum;

public class DefaultInstrumentFactory
implements ICounterSet.IInstrumentFactory {
    public static final DefaultInstrumentFactory OVERWRITE_60M = new DefaultInstrumentFactory(60, PeriodEnum.Minutes, true);
    public static final DefaultInstrumentFactory NO_OVERWRITE_60M = new DefaultInstrumentFactory(60, PeriodEnum.Minutes, false);
    private final int nslots;
    private final PeriodEnum period;
    private final boolean overwrite;

    public DefaultInstrumentFactory(int nslots, PeriodEnum period, boolean overwrite) {
        if (nslots <= 0) {
            throw new IllegalArgumentException();
        }
        if (period == null) {
            throw new IllegalArgumentException();
        }
        this.nslots = nslots;
        this.period = period;
        this.overwrite = overwrite;
    }

    @Override
    public IInstrument newInstance(Class type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (type == Double.class || type == Float.class) {
            History<Double> minutes = new History<Double>(new Double[this.nslots], this.period.getPeriodMillis(), this.overwrite);
            if (this.overwrite) {
                History<Double> hours = new History<Double>(24, minutes);
                new History<Double>(30, hours);
            }
            return new HistoryInstrument<Double>(minutes);
        }
        if (type == Long.class || type == Integer.class) {
            History<Long> minutes = new History<Long>(new Long[this.nslots], this.period.getPeriodMillis(), this.overwrite);
            if (this.overwrite) {
                History<Long> hours = new History<Long>(24, minutes);
                new History<Long>(30, hours);
            }
            return new HistoryInstrument<Long>(minutes);
        }
        if (type == String.class) {
            return new StringInstrument();
        }
        throw new UnsupportedOperationException("type: " + type);
    }

    static class StringInstrument
    extends Instrument<String> {
        StringInstrument() {
        }

        @Override
        public void sample() {
        }
    }
}

