/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.config;

import com.bigdata.config.ConfigurationException;
import com.bigdata.config.IValidator;

public class LongValidator
implements IValidator<Long> {
    public static final transient IValidator<Long> DEFAULT = new LongValidator();
    public static final transient IValidator<Long> GTE_ZERO = new LongValidator(){

        @Override
        public void accept(String key, String val, Long arg) {
            if (arg < 0L) {
                throw new ConfigurationException(key, val, "Must be non-negative");
            }
        }
    };
    public static final transient IValidator<Long> GT_ZERO = new LongValidator(){

        @Override
        public void accept(String key, String val, Long arg) {
            if (arg <= 0L) {
                throw new ConfigurationException(key, val, "Must be positive");
            }
        }
    };

    protected LongValidator() {
    }

    @Override
    public Long parse(String key, String val) {
        return Long.parseLong(val);
    }

    @Override
    public void accept(String key, String val, Long arg) throws ConfigurationException {
    }
}

