/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.concurrent;

import com.bigdata.cache.ConcurrentWeakValueCache;
import com.bigdata.concurrent.DeadlockException;
import com.bigdata.concurrent.ResourceQueue;
import com.bigdata.concurrent.TimeoutException;
import com.bigdata.concurrent.TxDag;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class LockManager<R extends Comparable<R>> {
    protected static final Logger log = Logger.getLogger(LockManager.class);
    protected final boolean INFO = log.isInfoEnabled();
    protected final boolean DEBUG = log.isDebugEnabled();
    private final ConcurrentWeakValueCache<R, ResourceQueue<R, Thread>> resourceQueues = new ConcurrentWeakValueCache(1000);
    private final ConcurrentHashMap<Thread, Collection<ResourceQueue<R, Thread>>> lockedResources;
    private final boolean predeclareLocks;
    private final boolean sortLockRequests;
    private final TxDag waitsFor;
    private CounterSet root;
    final AtomicLong nstarted = new AtomicLong(0L);
    final AtomicLong nended = new AtomicLong(0L);
    final AtomicLong nerror = new AtomicLong(0L);
    final AtomicLong ndeadlock = new AtomicLong(0L);
    final AtomicLong ntimeout = new AtomicLong(0L);
    final AtomicLong nwaiting = new AtomicLong(0L);
    final AtomicLong nrunning = new AtomicLong(0L);
    final AtomicLong maxrunning = new AtomicLong(0L);

    public synchronized CounterSet getCounters() {
        if (this.root == null) {
            this.root = new CounterSet();
            this.root.addCounter("nstarted", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(LockManager.this.nstarted.get());
                }
            });
            this.root.addCounter("nended", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(LockManager.this.nended.get());
                }
            });
            this.root.addCounter("nerror", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(LockManager.this.nerror.get());
                }
            });
            this.root.addCounter("ndeadlock", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(LockManager.this.ndeadlock.get());
                }
            });
            this.root.addCounter("ntimeout", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(LockManager.this.ntimeout.get());
                }
            });
            this.root.addCounter("nwaiting", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(LockManager.this.nwaiting.get());
                }
            });
            this.root.addCounter("nrunning", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(LockManager.this.nrunning.get());
                }
            });
            this.root.addCounter("maxRunning", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(LockManager.this.maxrunning.get());
                }
            });
        }
        return this.root;
    }

    public LockManager(int maxConcurrency, boolean predeclareLocks) {
        this(maxConcurrency, predeclareLocks, true);
    }

    LockManager(int maxConcurrency, boolean predeclareLocks, boolean sortLockRequests) {
        if (maxConcurrency < 2 && !predeclareLocks) {
            throw new IllegalArgumentException("maxConcurrency: must be 2+ unless you are predeclaring locks, not " + maxConcurrency);
        }
        if (predeclareLocks && !sortLockRequests) {
            throw new IllegalArgumentException("Sorting of lock requests MUST be enabled when locks are being predeclared.");
        }
        this.predeclareLocks = predeclareLocks;
        this.sortLockRequests = sortLockRequests;
        this.lockedResources = new ConcurrentHashMap(maxConcurrency);
        this.waitsFor = predeclareLocks ? null : new TxDag(maxConcurrency);
    }

    private ResourceQueue<R, Thread> declareResource(R resource) {
        ResourceQueue resourceQueue = (ResourceQueue)this.resourceQueues.get(resource);
        resourceQueue = new ResourceQueue(resource, this.waitsFor);
        ResourceQueue oldval = (ResourceQueue)this.resourceQueues.putIfAbsent(resource, resourceQueue);
        if (oldval != null) {
            return oldval;
        }
        return resourceQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropResource(R resource) {
        Thread tx = Thread.currentThread();
        ConcurrentWeakValueCache<R, ResourceQueue<R, Thread>> concurrentWeakValueCache = this.resourceQueues;
        synchronized (concurrentWeakValueCache) {
            ResourceQueue resourceQueue = (ResourceQueue)this.resourceQueues.get(resource);
            if (resourceQueue == null) {
                throw new IllegalArgumentException("No such resource: " + resource);
            }
            resourceQueue.clear(tx);
            this.resourceQueues.remove(resource);
        }
    }

    void lock(R[] resource, long timeout) throws InterruptedException, DeadlockException, TimeoutException {
        Collection<ResourceQueue<R, Thread>> resources;
        if (resource == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < resource.length; ++i) {
            if (resource[i] != null) continue;
            throw new NullPointerException();
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        if (resource.length == 0) {
            return;
        }
        Thread t = Thread.currentThread();
        if (this.predeclareLocks && (resources = this.lockedResources.get(t)) != null) {
            throw new IllegalStateException("Operation already has lock(s): " + t);
        }
        if (resource.length > 1 && this.sortLockRequests) {
            resource = (Comparable[])resource.clone();
            Arrays.sort(resource);
        }
        if (this.INFO) {
            log.info((Object)("Acquiring lock(s): " + Arrays.toString(resource)));
        }
        if (this.lockedResources.get(t) == null) {
            int initialCapacity = resource.length > 16 ? resource.length : 16;
            this.lockedResources.put(t, new LinkedHashSet(initialCapacity));
        }
        for (int i = 0; i < resource.length; ++i) {
            this.lock(t, resource[i], timeout);
        }
        if (this.INFO) {
            log.info((Object)("Acquired lock(s): " + Arrays.toString(resource)));
        }
    }

    private void lock(Thread t, R resource, long timeout) throws InterruptedException {
        ResourceQueue<R, Thread> resourceQueue = this.declareResource(resource);
        resourceQueue.lock(t, timeout);
        Collection<ResourceQueue<R, Thread>> tmp = this.lockedResources.get(t);
        if (tmp == null) {
            throw new AssertionError();
        }
        tmp.add(resourceQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseLocks(boolean waiting) {
        if (this.INFO) {
            log.info((Object)"Releasing locks");
        }
        Thread t = Thread.currentThread();
        try {
            Collection<ResourceQueue<R, Thread>> resources = this.lockedResources.remove(t);
            if (resources == null) {
                if (this.INFO) {
                    log.info((Object)("No locks: " + t));
                }
                return;
            }
            if (this.INFO) {
                log.info((Object)("Releasing resource locks: resources=" + resources));
            }
            for (ResourceQueue<R, Thread> resourceQueue : resources) {
                Comparable resource = (Comparable)resourceQueue.getResource();
                if (!this.resourceQueues.containsKey((Object)resource)) {
                    throw new IllegalStateException("No queue for resource: " + resource);
                }
                try {
                    resourceQueue.unlock(t);
                }
                catch (Throwable ex) {
                    log.warn((Object)"Could not release lock", ex);
                    continue;
                }
                if (!this.INFO) continue;
                log.info((Object)("Released lock: " + resource));
            }
            if (this.INFO) {
                log.info((Object)("Released resource locks: resources=" + resources));
            }
        }
        catch (Throwable ex) {
            log.error((Object)("Could not release locks: " + ex), ex);
        }
        finally {
            if (this.waitsFor != null) {
                this.waitsFor.releaseVertex(t);
            }
        }
    }

    void didStart(Callable task) {
        this.nstarted.incrementAndGet();
        if (this.INFO) {
            log.info((Object)("Started: nstarted=" + this.nstarted));
        }
    }

    void didSucceed(Callable task) {
        this.nended.incrementAndGet();
        try {
            boolean waiting = false;
            this.releaseLocks(false);
        }
        catch (Throwable t) {
            log.warn((Object)("Problem(s) releasing locks: " + t), t);
        }
        if (this.INFO) {
            log.info((Object)("Ended: nended=" + this.nended));
        }
    }

    void didAbort(Callable task, Throwable t, boolean waiting) {
        if (this.INFO) {
            log.info((Object)("Begin: nended=" + this.nended));
        }
        this.nerror.incrementAndGet();
        try {
            this.releaseLocks(waiting);
        }
        catch (Throwable t2) {
            log.warn((Object)("Problem(s) releasing locks: " + t2), t2);
        }
        if (this.INFO) {
            log.info((Object)("Ended: nended=" + this.nended));
        }
    }

    public String toString() {
        return this.getCounters().toString();
    }
}

