/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.proc;

import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.btree.proc.SplitValuePair;
import com.bigdata.service.Split;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractLocalSplitResultAggregator<R>
implements IResultHandler<R, R> {
    private final int size;
    private final ConcurrentHashMap<Split, R> map = new ConcurrentHashMap();

    public AbstractLocalSplitResultAggregator(int size) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        this.size = size;
    }

    @Override
    public void aggregate(R result, Split split) {
        this.map.put(split, result);
    }

    @Override
    public R getResult() {
        int nresults = this.map.size();
        SplitValuePair[] a = new SplitValuePair[nresults];
        int i = 0;
        for (Map.Entry<Split, R> e : this.map.entrySet()) {
            a[i++] = new SplitValuePair<Split, R>(e.getKey(), e.getValue());
        }
        if (a.length == 1) {
            return (R)a[0].val;
        }
        Arrays.sort(a, 0, a.length, new SplitValuePair.PairComparator());
        return this.newResult(this.size, a);
    }

    protected abstract R newResult(int var1, SplitValuePair<Split, R>[] var2);
}

