/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.keys;

import com.bigdata.btree.keys.DecompositionEnum;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.keys.StrengthEnum;
import com.bigdata.btree.keys.UnicodeSortKeyGenerator;
import java.text.Collator;
import java.util.Locale;

class JDKSortKeyGenerator
implements UnicodeSortKeyGenerator {
    private final Collator collator;
    private final Locale locale;

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public JDKSortKeyGenerator(Locale locale, Object strength, DecompositionEnum mode) {
        if (locale == null) {
            throw new IllegalArgumentException();
        }
        this.locale = locale;
        this.collator = Collator.getInstance(locale);
        if (strength != null) {
            if (strength instanceof Integer) {
                this.collator.setStrength((Integer)strength);
            } else {
                StrengthEnum str = (StrengthEnum)((Object)strength);
                switch (str) {
                    case Primary: {
                        this.collator.setStrength(0);
                        break;
                    }
                    case Secondary: {
                        this.collator.setStrength(1);
                        break;
                    }
                    case Tertiary: {
                        this.collator.setStrength(2);
                        break;
                    }
                    case Identical: {
                        this.collator.setStrength(3);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("strength=" + strength);
                    }
                }
            }
        }
        if (mode != null) {
            switch (mode) {
                case None: {
                    this.collator.setDecomposition(0);
                    break;
                }
                case Full: {
                    this.collator.setDecomposition(2);
                    break;
                }
                case Canonical: {
                    this.collator.setDecomposition(1);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("mode=" + (Object)((Object)mode));
                }
            }
        }
    }

    @Override
    public void appendSortKey(KeyBuilder keyBuilder, String s) {
        byte[] sortKey = this.collator.getCollationKey(s).toByteArray();
        keyBuilder.append(sortKey);
    }
}

