/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.IndexMetadata;
import com.bigdata.io.LongPacker;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ScatterSplitConfiguration
implements Externalizable {
    private static final long serialVersionUID = -1383416502823794570L;
    private boolean enabled;
    private double percentOfSplitThreshold;
    private int dataServiceCount;
    private int indexPartitionCount;
    private static final transient int VERSION0 = 0;

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getDataServiceCount() {
        return this.dataServiceCount;
    }

    public int getIndexPartitionCount() {
        return this.indexPartitionCount;
    }

    public double getPercentOfSplitThreshold() {
        return this.percentOfSplitThreshold;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("{enabled=" + this.enabled);
        sb.append(", percentOfSplitThreshold=" + this.percentOfSplitThreshold);
        sb.append(", dataServiceCount=" + this.dataServiceCount);
        sb.append(", indexPartitionCount=" + this.indexPartitionCount);
        sb.append("}");
        return sb.toString();
    }

    public ScatterSplitConfiguration() {
    }

    public ScatterSplitConfiguration(boolean enabled, double percentOfSplitThreshold, int dataServiceCount, int indexPartitionCount) {
        if (percentOfSplitThreshold < 0.1 || percentOfSplitThreshold > 1.0) {
            throw new IllegalArgumentException(IndexMetadata.Options.SCATTER_SPLIT_PERCENT_OF_SPLIT_THRESHOLD + " must be in [0.1:1.0]");
        }
        if (dataServiceCount < 0) {
            throw new IllegalArgumentException(IndexMetadata.Options.SCATTER_SPLIT_DATA_SERVICE_COUNT + " must be non-negative");
        }
        if (indexPartitionCount < 0) {
            throw new IllegalArgumentException(IndexMetadata.Options.SCATTER_SPLIT_INDEX_PARTITION_COUNT + " must be non-negative");
        }
        this.enabled = enabled;
        this.percentOfSplitThreshold = percentOfSplitThreshold;
        this.dataServiceCount = dataServiceCount;
        this.indexPartitionCount = indexPartitionCount;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = (int)LongPacker.unpackLong(in);
        if (version != 0) {
            throw new IOException("Unknown version: " + version);
        }
        this.enabled = in.readBoolean();
        this.percentOfSplitThreshold = in.readDouble();
        this.dataServiceCount = (int)LongPacker.unpackLong(in);
        this.indexPartitionCount = (int)LongPacker.unpackLong(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        LongPacker.packLong(out, 0L);
        out.writeBoolean(this.enabled);
        out.writeDouble(this.percentOfSplitThreshold);
        LongPacker.packLong(out, (long)this.dataServiceCount);
        LongPacker.packLong(out, (long)this.indexPartitionCount);
    }
}

