/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.AbstractNode;
import com.bigdata.btree.EvictionError;
import com.bigdata.btree.IEvictionListener;
import com.bigdata.btree.PO;
import com.bigdata.cache.IHardReferenceQueue;

public class DefaultEvictionListener
implements IEvictionListener {
    @Override
    public void evicted(IHardReferenceQueue<PO> cache, PO ref) {
        AbstractNode node = (AbstractNode)ref;
        if (--node.referenceCount > 0) {
            return;
        }
        this.doEviction(node);
    }

    private void doEviction(AbstractNode<?> node) {
        AbstractBTree btree = node.btree;
        if (btree.error != null) {
            throw new IllegalStateException("Index is in error state", btree.error);
        }
        try {
            assert (btree.isReadOnly() || btree.ndistinctOnWriteRetentionQueue > 0);
            --btree.ndistinctOnWriteRetentionQueue;
            if (node.deleted) {
                return;
            }
            if (node.dirty && btree.store != null) {
                if (node.isLeaf()) {
                    btree.writeNodeOrLeaf(node);
                } else {
                    btree.writeNodeRecursive(node);
                }
                assert (node.isCoded());
                assert (!node.dirty);
                if (btree.store != null) assert (node.identity != 0L);
            }
        }
        catch (Throwable e) {
            if (!btree.readOnly) {
                btree.error = e;
                throw new EvictionError(e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

