/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.AbstractNode;
import com.bigdata.btree.INodeIterator;
import com.bigdata.btree.Node;
import java.util.NoSuchElementException;

class ChildIterator
implements INodeIterator {
    private final Node node;
    private int index = 0;
    private int lastVisited = -1;
    private final int fromIndex;
    private final int toIndex;

    public ChildIterator(Node node) {
        this(node, null, null);
    }

    public ChildIterator(Node node, byte[] fromKey, byte[] toKey) {
        int toIndex;
        assert (node != null);
        this.node = node;
        int fromIndex = fromKey != null ? node.findChild(fromKey) : 0;
        this.fromIndex = fromIndex;
        if (toKey != null) {
            toIndex = node.findChild(toKey);
            if (this.fromIndex > toIndex) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            ++toIndex;
        } else {
            toIndex = node.getKeyCount() + 1;
        }
        this.toIndex = toIndex;
        this.index = this.fromIndex;
    }

    @Override
    public boolean hasNext() {
        return this.index >= this.fromIndex && this.index < this.toIndex;
    }

    @Override
    public AbstractNode next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.lastVisited = this.index++;
        return this.node.getChild(this.lastVisited);
    }

    @Override
    public AbstractNode getNode() {
        if (this.lastVisited == -1) {
            throw new IllegalStateException();
        }
        return this.node.getChild(this.lastVisited);
    }

    @Override
    public Object getKey() {
        if (this.lastVisited == -1) {
            throw new IllegalStateException();
        }
        return this.node.getKeys().get(this.lastVisited);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

