/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.rdf.aggregate;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.bop.aggregate.AggregateBase;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.rdf.sparql.ast.DummyConstantNode;
import java.util.Map;

public class GROUP_CONCAT
extends AggregateBase<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = 1L;
    private transient String sep;
    private transient int valueLimit;
    private transient int characterLimit;
    protected transient BigdataValueFactory vf;
    private transient StringBuilder aggregated = null;
    private transient long nvalues = 0L;
    private transient boolean done = false;
    private Throwable firstCause = null;

    public GROUP_CONCAT(GROUP_CONCAT op) {
        super(op);
    }

    public GROUP_CONCAT(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        if (!(this.getRequiredProperty(Annotations.NAMESPACE) instanceof String)) {
            throw new IllegalArgumentException();
        }
    }

    public GROUP_CONCAT(boolean distinct, IValueExpression<IV> expr, String namespace, String sep) {
        this(new BOp[]{expr}, NV.asMap(new NV(Annotations.DISTINCT, distinct), new NV(Annotations.NAMESPACE, namespace), new NV("separator", sep)));
    }

    private String sep() {
        if (this.sep == null) {
            this.sep = (String)this.getRequiredProperty("separator");
        }
        return this.sep;
    }

    private int valueLimit() {
        if (this.valueLimit == 0) {
            this.valueLimit = this.getProperty(Annotations.VALUE_LIMIT, -1);
        }
        return this.valueLimit;
    }

    private int characterLimit() {
        if (this.characterLimit == 0) {
            this.characterLimit = this.getProperty(Annotations.CHARACTER_LIMIT, -1);
        }
        return this.characterLimit;
    }

    private BigdataValueFactory getValueFactory() {
        if (this.vf == null) {
            String namespace = (String)this.getRequiredProperty(Annotations.NAMESPACE);
            this.vf = BigdataValueFactoryImpl.getInstance(namespace);
        }
        return this.vf;
    }

    @Override
    public synchronized void reset() {
        this.aggregated = null;
        this.nvalues = 0L;
        this.done = false;
        this.firstCause = null;
        this.cache();
    }

    private void cache() {
        this.sep();
        this.valueLimit();
        this.characterLimit();
        this.getValueFactory();
    }

    @Override
    public synchronized IV done() {
        if (this.sep == null) {
            this.cache();
        }
        if (this.firstCause != null) {
            throw new RuntimeException(this.firstCause);
        }
        BigdataValueFactory vf = this.getValueFactory();
        IV ret = this.aggregated == null ? DummyConstantNode.toDummyIV(vf.createLiteral("")) : DummyConstantNode.toDummyIV(vf.createLiteral(this.aggregated.toString()));
        return ret;
    }

    @Override
    public synchronized IV get(IBindingSet bindingSet) {
        try {
            return this.doGet(bindingSet);
        }
        catch (Throwable t) {
            if (this.firstCause == null) {
                this.firstCause = t;
            }
            throw new RuntimeException(t);
        }
    }

    private IV doGet(IBindingSet bindingSet) {
        IValueExpression expr;
        IV iv;
        if (this.sep == null) {
            this.cache();
        }
        if ((iv = (IV)(expr = (IValueExpression)this.get(0)).get(bindingSet)) != null && !this.done) {
            String str = IVValueExpression.asValue(iv).stringValue();
            if (this.aggregated == null) {
                this.aggregated = new StringBuilder(str);
            } else {
                this.aggregated.append(this.sep());
                this.aggregated.append(str);
            }
            ++this.nvalues;
            if (this.characterLimit() != -1 && this.aggregated.length() >= this.characterLimit) {
                this.aggregated.setLength(this.characterLimit);
                this.done = true;
            } else if (this.valueLimit() != -1 && this.nvalues >= (long)this.valueLimit) {
                this.done = true;
            }
        }
        return null;
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.ALWAYS;
    }

    public static interface Annotations
    extends AggregateBase.Annotations {
        public static final String NAMESPACE = GROUP_CONCAT.class.getName() + ".namespace";
        public static final String SEPARATOR = "separator";
        public static final String VALUE_LIMIT = GROUP_CONCAT.class.getName() + ".valueLimit";
        public static final int DEFAULT_VALUE_LIMIT = -1;
        public static final String CHARACTER_LIMIT = GROUP_CONCAT.class.getName() + ".characterLimit";
        public static final int DEFAULT_CHARACTER_LIMIT = -1;
    }
}

