/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.join;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IQueryAttributes;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.controller.INamedSolutionSetRef;
import com.bigdata.bop.controller.NamedSetAnnotations;
import com.bigdata.bop.join.BaseJoinStats;
import com.bigdata.bop.join.IHashJoinUtility;
import com.bigdata.bop.join.JoinAnnotations;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.relation.accesspath.UnsyncLocalOutputBuffer;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public abstract class SolutionSetHashJoinOp
extends PipelineOp {
    private static final long serialVersionUID = 1L;

    public SolutionSetHashJoinOp(SolutionSetHashJoinOp op) {
        super(op);
    }

    public SolutionSetHashJoinOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        if (this.getProperty(Annotations.RELEASE, true).booleanValue() && !this.isLastPassRequested()) {
            throw new IllegalArgumentException(Annotations.RELEASE + " requires " + Annotations.LAST_PASS);
        }
        this.getRequiredProperty("namedSetRef");
    }

    public SolutionSetHashJoinOp(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    @Override
    public BaseJoinStats newStats() {
        return new BaseJoinStats();
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new ChunkTask(context, this));
    }

    private static class ChunkTask<E>
    implements Callable<Void> {
        private final BOpContext<IBindingSet> context;
        private final SolutionSetHashJoinOp op;
        private final IHashJoinUtility state;
        private final IConstraint[] constraints;
        private final boolean release;
        private final BaseJoinStats stats;
        private final IBlockingBuffer<IBindingSet[]> sink;
        private final IBlockingBuffer<IBindingSet[]> sink2;

        public ChunkTask(BOpContext<IBindingSet> context, SolutionSetHashJoinOp op) {
            this.context = context;
            this.stats = (BaseJoinStats)context.getStats();
            this.release = op.getProperty(Annotations.RELEASE, true);
            this.sink = context.getSink();
            this.sink2 = context.getSink2();
            this.op = op;
            INamedSolutionSetRef namedSetRef = (INamedSolutionSetRef)op.getRequiredProperty("namedSetRef");
            IQueryAttributes attrs = context.getQueryAttributes(namedSetRef.getQueryId());
            this.state = (IHashJoinUtility)attrs.get(namedSetRef);
            if (this.state == null) {
                throw new RuntimeException("Not found: " + namedSetRef);
            }
            if (!this.state.getJoinType().isNormal() && !op.isLastPassRequested()) {
                throw new UnsupportedOperationException((Object)((Object)this.state.getJoinType()) + " requires " + Annotations.LAST_PASS);
            }
            this.constraints = BOpUtility.concat((IConstraint[])op.getProperty(Annotations.CONSTRAINTS), this.state.getConstraints());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                this.doHashJoin();
                Void void_ = null;
                return void_;
            }
            finally {
                if (this.release && this.context.isLastInvocation()) {
                    this.state.release();
                }
                this.sink.close();
                if (this.sink2 != null) {
                    this.sink2.close();
                }
            }
        }

        private void doHashJoin() {
            if (this.state.isEmpty()) {
                return;
            }
            this.stats.accessPathCount.increment();
            this.stats.accessPathRangeCount.add(this.state.getRightSolutionCount());
            UnsyncLocalOutputBuffer<IBindingSet> unsyncBuffer = new UnsyncLocalOutputBuffer<IBindingSet>(this.op.getChunkCapacity(), this.sink);
            this.state.hashJoin2(this.context.getSource(), this.stats, unsyncBuffer, this.constraints);
            if (this.context.isLastInvocation()) {
                this.doLastPass(unsyncBuffer);
            }
            unsyncBuffer.flush();
            this.sink.flush();
        }

        private void doLastPass(UnsyncLocalOutputBuffer<IBindingSet> unsyncBuffer) {
            switch (this.state.getJoinType()) {
                case Normal: {
                    break;
                }
                case Optional: 
                case NotExists: {
                    UnsyncLocalOutputBuffer<IBindingSet> unsyncBuffer2 = this.sink2 == null ? unsyncBuffer : new UnsyncLocalOutputBuffer<IBindingSet>(this.op.getChunkCapacity(), this.sink2);
                    this.state.outputOptionals((IBuffer<IBindingSet>)unsyncBuffer2);
                    unsyncBuffer2.flush();
                    if (this.sink2 == null) break;
                    this.sink2.flush();
                    break;
                }
                case Exists: {
                    IVariable<?> askVar = this.state.getAskVar();
                    this.state.outputJoinSet((IBuffer<IBindingSet>)unsyncBuffer);
                    if (askVar == null) break;
                    this.state.outputOptionals(unsyncBuffer);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    public static interface Annotations
    extends PipelineOp.Annotations,
    NamedSetAnnotations {
        public static final String CONSTRAINTS = JoinAnnotations.CONSTRAINTS;
        public static final String RELEASE = SolutionSetHashJoinOp.class + ".release";
        public static final boolean DEFAULT_RELEASE = true;
    }
}

