/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.join;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.controller.INamedSolutionSetRef;
import com.bigdata.bop.engine.AbstractRunningQuery;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.engine.IRunningQuery;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.join.HTreeHashJoinUtility;
import com.bigdata.bop.join.IHashJoinUtility;
import com.bigdata.bop.join.IHashJoinUtilityFactory;
import com.bigdata.bop.join.JoinTypeEnum;
import com.bigdata.bop.join.NamedSolutionSetStats;
import com.bigdata.bop.join.PipelinedHashIndexAndSolutionSetJoinOp;
import com.bigdata.bop.join.PipelinedHashJoinUtility;
import com.bigdata.bop.join.UnconstrainedJoinException;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.counters.CAT;
import com.bigdata.htree.HTree;
import com.bigdata.rdf.internal.impl.literal.XSDBooleanIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.relation.accesspath.BufferClosedException;
import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.relation.accesspath.UnsyncLocalOutputBuffer;
import com.bigdata.rwstore.sector.IMemoryManager;
import com.bigdata.rwstore.sector.MemStore;
import com.bigdata.util.InnerCause;
import com.bigdata.util.concurrent.IHaltable;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class HTreePipelinedHashJoinUtility
extends HTreeHashJoinUtility
implements PipelinedHashJoinUtility {
    private static final Logger log = Logger.getLogger(HTreePipelinedHashJoinUtility.class);
    protected final CAT nDistinctBindingSets = new CAT();
    protected final CAT nDistinctBindingSetsReleased = new CAT();
    protected final CAT nSubqueriesIssued = new CAT();
    protected final CAT nResultsFromSubqueries = new CAT();
    private final Set<IBindingSet> distinctProjectionBuffer = new HashSet<IBindingSet>();
    private final List<IBindingSet> incomingBindingsBuffer = new LinkedList<IBindingSet>();
    private HTree rightSolutionsWithoutSubqueryResult;
    private boolean bsFromBindingsSetSourceAddedToHashIndex = false;
    public static final IHashJoinUtilityFactory factory = new IHashJoinUtilityFactory(){
        private static final long serialVersionUID = 1L;

        @Override
        public IHashJoinUtility create(BOpContext<IBindingSet> context, INamedSolutionSetRef namedSetRef, PipelineOp op, JoinTypeEnum joinType) {
            return new HTreePipelinedHashJoinUtility(op, joinType, context, op.getChunkCapacity());
        }
    };

    public HTreePipelinedHashJoinUtility(IMemoryManager mmgr, PipelineOp op, JoinTypeEnum joinType) {
        super(mmgr, op, joinType);
    }

    public HTreePipelinedHashJoinUtility(PipelineOp op, JoinTypeEnum joinType, BOpContext<IBindingSet> context, int chunkCapacity) {
        super(context.getMemoryManager(null), op, joinType);
        if (!(op instanceof PipelinedHashIndexAndSolutionSetJoinOp)) {
            throw new IllegalArgumentException();
        }
        IMemoryManager mmgr = context.getMemoryManager(null);
        this.rightSolutionsWithoutSubqueryResult = HTree.create(new MemStore(mmgr.createAllocationContext()), HTreePipelinedHashJoinUtility.getIndexMetadata(op));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long acceptAndOutputSolutions(UnsyncLocalOutputBuffer<IBindingSet> out, ICloseableIterator<IBindingSet[]> itr, NamedSolutionSetStats stats, IConstraint[] joinConstraints, PipelineOp subquery, IBindingSet[] bsFromBindingsSetSource, IVariable<?>[] projectInVars, IVariable<?> askVar, boolean isLastInvocation, int distinctProjectionBufferThreshold, int incomingBindingsBufferThreshold, BOpContext<IBindingSet> context) {
        int i;
        if (!this.getOpen().get()) {
            throw new IllegalStateException();
        }
        HTree rightSolutions = this.getRightSolutions();
        IKeyBuilder keyBuilder = rightSolutions.getIndexMetadata().getKeyBuilder();
        if (bsFromBindingsSetSource != null) {
            this.addBindingsSetSourceToHashIndexOnce(rightSolutions, bsFromBindingsSetSource);
        }
        QueryEngine queryEngine = context.getRunningQuery().getQueryEngine();
        long naccepted = 0L;
        LinkedList<IBindingSet> dontRequireSubqueryEvaluation = new LinkedList<IBindingSet>();
        int nDistinctProjections = this.distinctProjectionBuffer.size();
        while (itr.hasNext()) {
            IBindingSet[] chunk = (IBindingSet[])itr.next();
            if (stats != null) {
                stats.chunksIn.increment();
                stats.unitsIn.add(chunk.length);
            }
            AtomicInteger vectorSize = new AtomicInteger();
            HTreeHashJoinUtility.BS[] a = this.vector(chunk, projectInVars, null, false, vectorSize);
            int n = vectorSize.get();
            if (subquery == null) {
                for (int i2 = 0; i2 < n; ++i2) {
                    dontRequireSubqueryEvaluation.add(a[i2].bset);
                }
                continue;
            }
            try {
                HashMap<IBindingSet, Boolean> joinsCache = new HashMap<IBindingSet, Boolean>();
                for (i = 0; i < n; ++i) {
                    boolean bSetDistinctJoins;
                    IBindingSet curBs = a[i].bset;
                    IBindingSet bsetDistinct = curBs.copy(projectInVars);
                    if (joinsCache.containsKey(bsetDistinct)) {
                        bSetDistinctJoins = (Boolean)joinsCache.get(bsetDistinct);
                    } else {
                        bSetDistinctJoins = this.joinsWith(a[i], keyBuilder, rightSolutions, this.rightSolutionsWithoutSubqueryResult);
                        joinsCache.put(bsetDistinct, bSetDistinctJoins);
                    }
                    if (bSetDistinctJoins) {
                        dontRequireSubqueryEvaluation.add(curBs);
                    } else {
                        this.incomingBindingsBuffer.add(curBs);
                        this.distinctProjectionBuffer.add(bsetDistinct);
                    }
                    ++naccepted;
                }
            }
            catch (Throwable t) {
                boolean isDone = context.getRunningQuery().isDone();
                throw new RuntimeException("Query is done: " + isDone, t);
            }
        }
        this.nDistinctBindingSets.add(this.distinctProjectionBuffer.size() - nDistinctProjections);
        if (!dontRequireSubqueryEvaluation.isEmpty()) {
            this.hashJoinAndEmit(dontRequireSubqueryEvaluation.toArray(new IBindingSet[0]), stats, out, joinConstraints, askVar);
        }
        if (this.distinctProjectionBuffer.isEmpty()) {
            return naccepted;
        }
        if (!isLastInvocation && !this.thresholdExceeded(this.distinctProjectionBuffer, distinctProjectionBufferThreshold, this.incomingBindingsBuffer, incomingBindingsBufferThreshold)) {
            return naccepted;
        }
        assert (subquery != null);
        IHaltable runningSubquery = null;
        try {
            runningSubquery = queryEngine.eval((BOp)subquery, this.distinctProjectionBuffer.toArray(new IBindingSet[0]));
            ((AbstractRunningQuery)context.getRunningQuery()).addChild((IRunningQuery)runningSubquery);
            this.nDistinctBindingSetsReleased.add(this.distinctProjectionBuffer.size());
            this.nSubqueriesIssued.increment();
            try (ICloseableIterator<IBindingSet[]> subquerySolutionItr = runningSubquery.iterator();){
                while (subquerySolutionItr.hasNext()) {
                    IBindingSet[] solutions = (IBindingSet[])subquerySolutionItr.next();
                    AtomicInteger vectorSize = new AtomicInteger();
                    HTreeHashJoinUtility.BS[] a = this.vector(solutions, this.getJoinVars(), null, false, vectorSize);
                    int n = vectorSize.get();
                    for (int i3 = 0; i3 < n; ++i3) {
                        HTreeHashJoinUtility.BS tmp = a[i3];
                        byte[] key = keyBuilder.reset().append(tmp.hashCode).getKey();
                        byte[] val = this.getEncoder().encodeSolution(tmp.bset);
                        rightSolutions.insert(key, val);
                    }
                    for (IBindingSet solution : solutions) {
                        this.distinctProjectionBuffer.remove(solution.copy(this.getJoinVars()));
                        this.nResultsFromSubqueries.increment();
                    }
                }
                this.getEncoder().flush();
                AtomicInteger vectorSize = new AtomicInteger();
                HTreeHashJoinUtility.BS[] vectoredDistinctProjectionBuffer = this.vector(this.distinctProjectionBuffer.toArray(new IBindingSet[0]), this.getJoinVars(), null, false, vectorSize);
                int n = vectorSize.get();
                for (i = 0; i < n; ++i) {
                    HTreeHashJoinUtility.BS tmp = vectoredDistinctProjectionBuffer[i];
                    byte[] key = keyBuilder.reset().append(tmp.hashCode).getKey();
                    byte[] val = this.getEncoder().encodeSolution(tmp.bset);
                    this.rightSolutionsWithoutSubqueryResult.insert(key, val);
                }
            }
            runningSubquery.get();
        }
        catch (Throwable t) {
            Throwable cause = runningSubquery != null && runningSubquery.getCause() != null ? runningSubquery.getCause() : t;
            throw new RuntimeException(context.getRunningQuery().halt(cause));
        }
        finally {
            if (runningSubquery != null) {
                runningSubquery.cancel(true);
            }
        }
        this.hashJoinAndEmit(this.incomingBindingsBuffer.toArray(new IBindingSet[0]), stats, out, joinConstraints, askVar);
        this.distinctProjectionBuffer.clear();
        this.incomingBindingsBuffer.clear();
        return naccepted;
    }

    protected boolean joinsWith(HTreeHashJoinUtility.BS bs, IKeyBuilder keyBuilder, HTree rightSolutions, HTree rightSolutionsWithoutSubqueryResult) {
        return this.joinsWith(bs, keyBuilder, rightSolutions) || this.joinsWith(bs, keyBuilder, rightSolutionsWithoutSubqueryResult);
    }

    protected boolean joinsWith(HTreeHashJoinUtility.BS bs, IKeyBuilder keyBuilder, HTree htree) {
        int hashCode = bs.hashCode;
        byte[] key = keyBuilder.reset().append(hashCode).getKey();
        if (!htree.contains(key)) {
            return false;
        }
        ITupleIterator titr = htree.lookupAll(key);
        while (titr.hasNext()) {
            ITuple t = titr.next();
            IBindingSet joinCandidate = this.decodeSolution(t);
            if (BOpContext.bind(bs.bset, joinCandidate, null, this.getSelectVars()) == null) continue;
            return true;
        }
        return false;
    }

    boolean thresholdExceeded(Set<IBindingSet> distinctProjectionBuffer, int distinctProjectionBufferThreshold, List<IBindingSet> incomingBindingsBuffer, int incomingBindingsBufferThreshold) {
        return distinctProjectionBuffer.size() >= distinctProjectionBufferThreshold || incomingBindingsBuffer.size() >= incomingBindingsBufferThreshold;
    }

    void addBindingsSetSourceToHashIndexOnce(HTree rightSolutions, IBindingSet[] bsFromBindingsSetSource) {
        if (!this.bsFromBindingsSetSourceAddedToHashIndex) {
            IKeyBuilder keyBuilder = rightSolutions.getIndexMetadata().getKeyBuilder();
            AtomicInteger vectorSize = new AtomicInteger();
            HTreeHashJoinUtility.BS[] a = this.vector(bsFromBindingsSetSource, this.getJoinVars(), null, false, vectorSize);
            int n = vectorSize.get();
            for (int i = 0; i < n; ++i) {
                HTreeHashJoinUtility.BS tmp = a[i];
                byte[] key = keyBuilder.reset().append(tmp.hashCode).getKey();
                byte[] val = this.getEncoder().encodeSolution(tmp.bset);
                rightSolutions.insert(key, val);
            }
            this.getEncoder().flush();
            this.bsFromBindingsSetSourceAddedToHashIndex = true;
        }
    }

    public void hashJoinAndEmit(IBindingSet[] chunk, BOpStats stats, IBuffer<IBindingSet> outputBuffer, IConstraint[] joinConstraints, IVariable<?> askVar) {
        boolean noJoinVars;
        if (!this.getOpen().get()) {
            throw new IllegalStateException();
        }
        HTree rightSolutions = this.getRightSolutions();
        IKeyBuilder keyBuilder = rightSolutions.getIndexMetadata().getKeyBuilder();
        if (log.isInfoEnabled()) {
            log.info((Object)("rightSolutions: #nnodes=" + rightSolutions.getNodeCount() + ",#leaves=" + rightSolutions.getLeafCount() + ",#entries=" + rightSolutions.getEntryCount()));
        }
        boolean bl = noJoinVars = this.getJoinVars().length == 0;
        if (stats != null) {
            stats.chunksIn.increment();
            stats.unitsIn.add(chunk.length);
        }
        AtomicInteger vectorSize = new AtomicInteger();
        HTreeHashJoinUtility.BS[] a = this.vector(chunk, this.getJoinVars(), null, false, vectorSize);
        int n = vectorSize.get();
        this.nleftConsidered.add(n);
        int fromIndex = 0;
        while (fromIndex < n) {
            int hashCode = a[fromIndex].hashCode;
            int toIndex = n;
            for (int i = fromIndex + 1; i < n; ++i) {
                if (a[i].hashCode == hashCode) continue;
                toIndex = i;
                break;
            }
            int bucketSize = toIndex - fromIndex;
            if (log.isTraceEnabled()) {
                log.trace((Object)("hashCode=" + hashCode + ": #left=" + bucketSize + ", vectorSize=" + n + ", firstLeft=" + a[fromIndex]));
            }
            int njoined = 0;
            int nrejected = 0;
            byte[] key = keyBuilder.reset().append(hashCode).getKey();
            ITupleIterator titr = rightSolutions.lookupAll(key);
            long sameHashCodeCount = 0L;
            LinkedHashSet<IBindingSet> leftSolutionsWithoutMatch = new LinkedHashSet<IBindingSet>();
            LinkedHashSet<IBindingSet> existsSolutions = new LinkedHashSet<IBindingSet>();
            if (!titr.hasNext()) {
                for (int i = fromIndex; i < toIndex; ++i) {
                    IBindingSet leftSolution = a[i].bset;
                    leftSolutionsWithoutMatch.add(leftSolution);
                }
            } else {
                while (titr.hasNext()) {
                    ++sameHashCodeCount;
                    ITuple t = titr.next();
                    IBindingSet rightSolution = this.decodeSolution(t);
                    this.nrightConsidered.increment();
                    block19: for (int i = fromIndex; i < toIndex; ++i) {
                        IBindingSet leftSolution = a[i].bset;
                        leftSolutionsWithoutMatch.add(leftSolution);
                        IBindingSet outSolution = BOpContext.bind(leftSolution, rightSolution, this.getConstraints(), this.getSelectVars());
                        this.nJoinsConsidered.increment();
                        if (noJoinVars && this.nJoinsConsidered.get() == this.getNoJoinVarsLimit() && this.nleftConsidered.get() > 1L && this.nrightConsidered.get() > 1L) {
                            throw new UnconstrainedJoinException();
                        }
                        if (outSolution == null) {
                            ++nrejected;
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Does not join: hashCode=" + hashCode + ", sameHashCodeCount=" + sameHashCodeCount + ", #left=" + bucketSize + ", #joined=" + njoined + ", #rejected=" + nrejected + ", left=" + leftSolution + ", right=" + rightSolution));
                            }
                        } else {
                            ++njoined;
                            leftSolutionsWithoutMatch.remove(leftSolution);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("JOIN: hashCode=" + hashCode + ", sameHashCodeCount=" + sameHashCodeCount + ", #left=" + bucketSize + ", #joined=" + njoined + ", #rejected=" + nrejected + ", solution=" + outSolution));
                            }
                        }
                        switch (this.getJoinType()) {
                            case Normal: 
                            case Optional: {
                                if (outSolution == null) continue block19;
                                this.getEncoder().resolveCachedValues(outSolution);
                                if (askVar != null) {
                                    outSolution.set(askVar, new Constant<XSDBooleanIV<BigdataLiteral>>(XSDBooleanIV.TRUE));
                                }
                                outputBuffer.add(outSolution);
                                continue block19;
                            }
                            case Exists: {
                                if (askVar == null) continue block19;
                                existsSolutions.add(leftSolution);
                                continue block19;
                            }
                            case NotExists: {
                                continue block19;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                    }
                }
            }
            block20: for (IBindingSet leftSolutionWithoutMatch : leftSolutionsWithoutMatch) {
                switch (this.getJoinType()) {
                    case Optional: 
                    case NotExists: {
                        outputBuffer.add(leftSolutionWithoutMatch);
                        continue block20;
                    }
                    case Exists: {
                        if (askVar == null) continue block20;
                        leftSolutionWithoutMatch.set(askVar, new Constant<XSDBooleanIV<BigdataLiteral>>(XSDBooleanIV.FALSE));
                        outputBuffer.add(leftSolutionWithoutMatch);
                        continue block20;
                    }
                    case Normal: {
                        continue block20;
                    }
                }
                throw new AssertionError();
            }
            block21: for (IBindingSet existsSolution : existsSolutions) {
                switch (this.getJoinType()) {
                    case Optional: 
                    case NotExists: {
                        continue block21;
                    }
                    case Exists: {
                        if (askVar == null) continue block21;
                        existsSolution.set(askVar, new Constant<XSDBooleanIV<BigdataLiteral>>(XSDBooleanIV.TRUE));
                        outputBuffer.add(existsSolution);
                        continue block21;
                    }
                    case Normal: {
                        continue block21;
                    }
                }
                throw new AssertionError();
            }
            fromIndex = toIndex;
        }
    }

    protected RuntimeException launderThrowable(Throwable t) {
        String msg = "cause=" + t + ", state=" + this.toString();
        if (!InnerCause.isInnerCause((Throwable)t, InterruptedException.class) && !InnerCause.isInnerCause((Throwable)t, BufferClosedException.class)) {
            log.error((Object)msg, t);
        }
        return new RuntimeException(msg, t);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{open=" + this.getOpen());
        sb.append(",joinType=" + (Object)((Object)this.getJoinType()));
        if (this.getAskVar() != null) {
            sb.append(",askVar=" + this.getAskVar());
        }
        sb.append(",joinVars=" + Arrays.toString(this.getJoinVars()));
        sb.append(",outputDistinctJVs=" + this.getOutputDistintcJVs());
        if (this.getSelectVars() != null) {
            sb.append(",selectVars=" + Arrays.toString(this.getSelectVars()));
        }
        if (this.getConstraints() != null) {
            sb.append(",constraints=" + Arrays.toString(this.getConstraints()));
        }
        sb.append(",size=" + this.getRightSolutionCount());
        sb.append(", distinctProjectionsWithoutSubqueryResult=" + this.rightSolutionsWithoutSubqueryResult.getEntryCount());
        sb.append(", distinctBindingSets (seen/released)=" + this.nDistinctBindingSets + "/" + this.nDistinctBindingSetsReleased);
        sb.append(", subqueriesIssued=" + this.nSubqueriesIssued);
        sb.append(", resultsFromSubqueries=" + this.nResultsFromSubqueries);
        sb.append(",considered(left=" + this.nleftConsidered + ",right=" + this.nrightConsidered + ",joins=" + this.nJoinsConsidered + ")");
        if (this.getJoinSet() != null) {
            sb.append(",joinSetSize=" + this.getJoinSetSize());
        }
        sb.append("}");
        return sb.toString();
    }
}

