/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.fed.shards;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.fed.shards.Algorithm_NestedLocatorScan;
import com.bigdata.bop.fed.shards.Bundle;
import com.bigdata.bop.fed.shards.IShardMapper;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.journal.NoSuchIndexException;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.mdi.IMetadataIndex;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.accesspath.AbstractUnsynchronizedArrayBuffer;
import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.service.AbstractScaleOutFederation;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.striterator.IKeyOrder;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class MapBindingSetsOverShardsBuffer<E extends IBindingSet, F>
extends AbstractUnsynchronizedArrayBuffer<E> {
    protected final AbstractScaleOutFederation<?> fed;
    protected final IPredicate<F> pred;
    protected final long timestamp;
    protected final IRelation<F> relation;
    private final IShardMapper<E, F> algorithm;
    private final LinkedHashMap<PartitionLocator, IBuffer<IBindingSet[]>> sinks = new LinkedHashMap();

    public MapBindingSetsOverShardsBuffer(IBigdataFederation<?> fed, IPredicate<F> pred, long timestamp, int capacity) {
        super(capacity, IBindingSet.class);
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        if (pred == null) {
            throw new IllegalArgumentException();
        }
        this.fed = (AbstractScaleOutFederation)fed;
        this.pred = pred;
        this.timestamp = timestamp;
        String namespace = pred.getOnlyRelationName();
        this.relation = (IRelation)fed.getResourceLocator().locate(namespace, timestamp);
        if (this.relation == null) {
            throw new RuntimeException("Not found: relation=" + namespace + "@" + TimestampUtility.toString(timestamp));
        }
        boolean predicateWillBeFullyBound = false;
        this.algorithm = new Algorithm_NestedLocatorScan(this);
    }

    protected IMetadataIndex getMetadataIndex(IKeyOrder<F> keyOrder) {
        String namespace = this.relation.getFQN(keyOrder);
        IMetadataIndex mdi = this.fed.getMetadataIndex(namespace, this.timestamp);
        if (mdi == null) {
            throw new NoSuchIndexException("name=" + namespace + ", timestamp=" + TimestampUtility.toString(this.timestamp));
        }
        return mdi;
    }

    @Override
    protected void handleChunk(E[] chunk) {
        Bundle[] bundles = new Bundle[chunk.length];
        for (int i = 0; i < chunk.length; ++i) {
            E bindingSet = chunk[i];
            IPredicate<F> asBound = this.pred.asBound((IBindingSet)bindingSet);
            IKeyOrder<F> keyOrder = this.relation.getKeyOrder(asBound);
            IKeyBuilder keyBuilder = this.relation.getIndex(keyOrder).getIndexMetadata().getKeyBuilder();
            bundles[i] = new Bundle<F>(keyBuilder, asBound, keyOrder, (IBindingSet)bindingSet);
        }
        this.algorithm.mapOverShards(bundles);
    }

    protected Iterator<PartitionLocator> locatorScan(IKeyOrder<F> keyOrder, byte[] fromKey, byte[] toKey) {
        String name = this.relation.getFQN(keyOrder);
        return this.fed.locatorScan(name, this.timestamp, fromKey, toKey, false);
    }

    @Override
    public long flush() {
        long n = super.flush();
        for (IBuffer<IBindingSet[]> sink : this.sinks.values()) {
            if (sink.isEmpty()) continue;
            sink.flush();
        }
        return n;
    }

    public Map<PartitionLocator, IBuffer<IBindingSet[]>> getSinks() {
        return Collections.unmodifiableMap(this.sinks);
    }

    protected IBuffer<IBindingSet[]> getBuffer(PartitionLocator locator) {
        IBuffer<IBindingSet[]> sink = this.sinks.get(locator);
        if (sink == null) {
            sink = this.newBuffer(locator);
            this.sinks.put(locator, sink);
        }
        return sink;
    }

    protected abstract IBuffer<IBindingSet[]> newBuffer(PartitionLocator var1);
}

