/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.engine;

import com.bigdata.bop.engine.IRunningQuery;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.concurrent.atomic.AtomicBoolean;

class QueryResultIterator<E>
implements ICloseableIterator<E> {
    private final IRunningQuery runningQuery;
    private final ICloseableIterator<E> src;
    private final AtomicBoolean open = new AtomicBoolean(true);

    public QueryResultIterator(IRunningQuery runningQuery, ICloseableIterator<E> src) {
        if (runningQuery == null) {
            throw new IllegalArgumentException();
        }
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.runningQuery = runningQuery;
        this.src = src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.open.compareAndSet(true, false)) {
            try {
                this.runningQuery.cancel(true);
            }
            finally {
                this.src.close();
            }
        }
    }

    private void normalCompletion() {
        if (this.open.compareAndSet(true, false)) {
            this.src.close();
        }
    }

    public boolean hasNext() {
        if (!this.src.hasNext()) {
            this.normalCompletion();
            return false;
        }
        return true;
    }

    public E next() {
        return (E)this.src.next();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

