/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.cost;

import com.bigdata.bop.cost.DiskCostModel;
import java.io.Serializable;
import java.text.NumberFormat;

public class BTreeCostModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final DiskCostModel diskCostModel;

    public BTreeCostModel(DiskCostModel diskCostModel) {
        if (diskCostModel == null) {
            throw new IllegalArgumentException();
        }
        this.diskCostModel = diskCostModel;
    }

    public static int estimateHeight(int entryCount, int branchingFactor) {
        if (entryCount < branchingFactor) {
            return 0;
        }
        double logm = Math.log(branchingFactor);
        double logn = Math.log(entryCount);
        double h = logm / logn - 1.0;
        return (int)Math.ceil(h);
    }

    public double rangeScan(long rangeCount, int m, int h, int leafUtilization) {
        if (rangeCount == 0L) {
            return 0.0;
        }
        double averageSeekTime = (double)Math.max(0, h - 1) * this.diskCostModel.seekTime;
        double leafFillRate = (double)leafUtilization / 100.0;
        double expectedLeafCount = Math.ceil((double)rangeCount / (double)m * Math.min(1.0, 1.0 / leafFillRate));
        double estimatedCost = averageSeekTime * expectedLeafCount;
        return estimatedCost;
    }

    public static void main(String[] args) {
        DiskCostModel[] diskCostModels = new DiskCostModel[]{DiskCostModel.DEFAULT};
        int[] branchingFactors = new int[]{32, 64, 128, 256, 512, 1024};
        int[] heights = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        int[] rangeCounts = new int[]{1, 10, 100, 1000, 2000, 5000, 10000, 2000, 50000, 100000};
        int leafUtilization = 65;
        System.out.println("seekTime\txferRate\tleafUtil\tm\theight\trangeCount\tcost(ms)");
        NumberFormat millisFormat = NumberFormat.getIntegerInstance();
        millisFormat.setGroupingUsed(true);
        NumberFormat percentFormat = NumberFormat.getPercentInstance();
        percentFormat.setMinimumFractionDigits(0);
        StringBuilder sb = new StringBuilder();
        for (DiskCostModel diskCostModel : diskCostModels) {
            BTreeCostModel btreeCostModel = new BTreeCostModel(diskCostModel);
            for (int m : branchingFactors) {
                for (int h : heights) {
                    int rangeCount;
                    int estimatedHeight;
                    int[] arr$ = rangeCounts;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (estimatedHeight = BTreeCostModel.estimateHeight(rangeCount = arr$[i$], m)) <= h; ++i$) {
                        double cost = btreeCostModel.rangeScan(rangeCount, m, h, 65);
                        sb.setLength(0);
                        sb.append(millisFormat.format(diskCostModel.seekTime));
                        sb.append('\t');
                        sb.append(millisFormat.format(diskCostModel.transferRate));
                        sb.append('\t');
                        sb.append(percentFormat.format(0.65));
                        sb.append('\t');
                        sb.append(m);
                        sb.append('\t');
                        sb.append(h);
                        sb.append('\t');
                        sb.append(rangeCount);
                        sb.append('\t');
                        sb.append(millisFormat.format(cost));
                        System.out.println(sb);
                    }
                }
            }
        }
    }
}

