/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.constraint;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.constraint.INConstraint;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class INHashMap<T>
extends INConstraint<T> {
    private static final long serialVersionUID = 8032412126003678642L;
    private volatile transient IVariable<T> var;
    private volatile transient ConcurrentHashMap<T, T> set;

    public INHashMap(INHashMap<T> op) {
        super(op);
    }

    public INHashMap(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
    }

    public INHashMap(IVariable<T> x, IConstant<T>[] set) {
        super(new BOp[0], NV.asMap(new NV(INConstraint.Annotations.VARIABLE, x), new NV(INConstraint.Annotations.SET, set)));
    }

    private void init() {
        this.var = this.getVariable();
        IConstant<T>[] a = this.getSet();
        this.set = new ConcurrentHashMap(a.length);
        for (IConstant t : a) {
            Object val = t.get();
            this.set.put(val, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean get(IBindingSet bindingSet) {
        IConstant x;
        if (this.var == null) {
            INHashMap iNHashMap = this;
            synchronized (iNHashMap) {
                if (this.var == null) {
                    this.init();
                }
            }
        }
        if ((x = bindingSet.get(this.var)) == null) {
            return true;
        }
        Object v = x.get();
        boolean found = this.set.containsKey(v);
        return found;
    }
}

