/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop;

import com.bigdata.bop.BOp;
import com.bigdata.bop.CoreBaseBOp;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class BOpBase
extends CoreBaseBOp {
    private static final long serialVersionUID = 1L;
    private final BOp[] args;
    private final Map<String, Object> annotations;

    public BOpBase(BOpBase op) {
        this.args = op.args == BOp.NOARGS || op.args.length == 0 ? BOp.NOARGS : Arrays.copyOf(op.args, op.args.length);
        this.annotations = new LinkedHashMap<String, Object>(op.annotations);
    }

    public BOpBase(BOp[] args, Map<String, Object> annotations) {
        if (args == null) {
            throw new IllegalArgumentException();
        }
        this.checkArgs(args);
        this.args = args;
        this.annotations = annotations == null ? new LinkedHashMap(2) : annotations;
    }

    public final Map<String, Object> annotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    @Override
    protected boolean annotationsEqual(BOp o) {
        if (o instanceof BOpBase) {
            return BOpBase.annotationsEqual(this.annotations, ((BOpBase)o).annotations);
        }
        return CoreBaseBOp.annotationsEqual(this.annotations, o.annotations());
    }

    protected final BOp[] argsCopy() {
        BOp[] tmp = new BOp[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            tmp[i] = this.args[i];
        }
        return tmp;
    }

    protected final Map<String, Object> annotationsCopy() {
        return new LinkedHashMap<String, Object>(this.annotations);
    }

    protected final Map<String, Object> annotationsRef() {
        return this.annotations;
    }

    public BOp get(int index) {
        return this.args[index];
    }

    protected final void _set(int index, BOp op) {
        this.args[index] = op;
    }

    public BOpBase setArg(int index, BOp newArg) {
        if (newArg == null) {
            throw new IllegalArgumentException();
        }
        BOpBase tmp = (BOpBase)this.clone();
        tmp._set(index, newArg);
        return tmp;
    }

    public int arity() {
        return this.args.length;
    }

    public final List<BOp> args() {
        return Collections.unmodifiableList(Arrays.asList(this.args));
    }

    public final Iterator<BOp> argIterator() {
        return new ArgIterator();
    }

    public BOp[] toArray() {
        BOp[] a = new BOp[this.args.length];
        return (BOp[])Arrays.copyOf(this.args, this.args.length, a.getClass());
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.args.length) {
            return Arrays.copyOf(this.args, this.args.length, a.getClass());
        }
        System.arraycopy(this.args, 0, a, 0, this.args.length);
        if (a.length > this.args.length) {
            a[this.args.length] = null;
        }
        return a;
    }

    protected static BOp[] deepCopy(BOp[] a) {
        if (a == BOp.NOARGS || a.length == 0) {
            return BOp.NOARGS;
        }
        BOp[] t = new BOp[a.length];
        for (int i = 0; i < a.length; ++i) {
            t[i] = a[i] == null ? null : a[i].clone();
        }
        return t;
    }

    protected static Map<String, Object> deepCopy(Map<String, Object> a) {
        if (a == BOp.NOANNS) {
            return a;
        }
        LinkedHashMap<String, Object> t = new LinkedHashMap<String, Object>(a.size());
        for (Map.Entry<String, Object> e : a.entrySet()) {
            if (e.getValue() instanceof BOp) {
                t.put(e.getKey(), ((BOp)e.getValue()).clone());
                continue;
            }
            t.put(e.getKey(), e.getValue());
        }
        return t;
    }

    public Object getProperty(String name) {
        return this.annotations.get(name);
    }

    protected Object _setProperty(String name, Object value) {
        return this.annotations.put(name, value);
    }

    protected void _clearProperty(String name) {
        this.annotations.remove(name);
    }

    public BOpBase setProperty(String name, Object value) {
        BOpBase tmp = (BOpBase)this.clone();
        tmp._setProperty(name, value);
        return tmp;
    }

    public BOpBase setUnboundProperty(String name, Object value) {
        BOpBase tmp = (BOpBase)this.clone();
        if (tmp._setProperty(name, value) != null) {
            throw new IllegalStateException("Already set: name=" + name + ", value=" + value);
        }
        return tmp;
    }

    public BOpBase clearProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        BOpBase tmp = (BOpBase)this.clone();
        tmp._clearProperty(name);
        return tmp;
    }

    public BOp clearAnnotations(String[] names) {
        BOpBase tmp = (BOpBase)this.clone();
        for (String name : names) {
            tmp._clearProperty(name);
        }
        return tmp;
    }

    private class ArgIterator
    implements Iterator<BOp> {
        private int i = 0;

        private ArgIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < BOpBase.this.args.length;
        }

        @Override
        public BOp next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return BOpBase.this.args[this.i++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

