/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.renderer;

import java.io.PrintWriter;
import java.util.Set;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.IllegalElementNameException;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.RDFXMLRenderer;
import org.semanticweb.owlapi.util.AbstractOWLStorer;

public class RDFXMLStorer
extends AbstractOWLStorer {
    public boolean canStoreOntology(OWLDocumentFormat ontologyFormat) {
        return ontologyFormat instanceof RDFXMLDocumentFormat;
    }

    protected void storeOntology(OWLOntology ontology, PrintWriter writer, OWLDocumentFormat format) throws OWLOntologyStorageException {
        try {
            RDFXMLRenderer renderer = new RDFXMLRenderer(ontology, writer, format);
            Set<OWLEntity> entities = renderer.getUnserialisableEntities();
            if (!entities.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (OWLEntity entity : entities) {
                    sb.append(entity.toStringID());
                    sb.append('\n');
                }
                throw new OWLOntologyStorageException(sb.toString().trim(), (Throwable)((Object)new IllegalElementNameException(sb.toString().trim())));
            }
            renderer.render();
        }
        catch (OWLRuntimeException e) {
            throw new OWLOntologyStorageException((Throwable)e);
        }
    }
}

