/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.datatypes;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.util.LiteralUtilException;
import org.openrdf.rio.DatatypeHandler;

public class VirtuosoGeometryDatatypeHandler
implements DatatypeHandler {
    private static final URI VIRTRDF_GEOMETRY = ValueFactoryImpl.getInstance().createURI("http://www.openlinksw.com/schemas/virtrdf#", "Geometry");
    private static final String POINT_START = "POINT(";
    private static final String POINT_END = ")";
    private static final String POINT_SEPERATOR = " ";

    public boolean isRecognizedDatatype(URI datatypeUri) {
        if (datatypeUri == null) {
            throw new NullPointerException("Datatype URI cannot be null");
        }
        return VIRTRDF_GEOMETRY.equals((Object)datatypeUri);
    }

    public boolean verifyDatatype(String literalValue, URI datatypeUri) throws LiteralUtilException {
        if (this.isRecognizedDatatype(datatypeUri)) {
            return this.verifyDatatypeInternal(literalValue, datatypeUri);
        }
        throw new LiteralUtilException("Could not verify Virtuoso Geometry literal");
    }

    public Literal normalizeDatatype(String literalValue, URI datatypeUri, ValueFactory valueFactory) throws LiteralUtilException {
        if (this.isRecognizedDatatype(datatypeUri) && this.verifyDatatypeInternal(literalValue, datatypeUri)) {
            return valueFactory.createLiteral(literalValue, datatypeUri);
        }
        throw new LiteralUtilException("Could not normalise Virtuoso Geometry literal");
    }

    public String getKey() {
        return "org.openrdf.rio.datatypes.virtuosogeometry";
    }

    private boolean verifyDatatypeInternal(String literalValue, URI datatypeUri) throws LiteralUtilException {
        if (literalValue == null) {
            throw new NullPointerException("Literal value cannot be null");
        }
        if (VIRTRDF_GEOMETRY.equals((Object)datatypeUri)) {
            if (!literalValue.startsWith(POINT_START)) {
                return false;
            }
            if (!literalValue.endsWith(POINT_END)) {
                return false;
            }
            String valueString = literalValue.substring(POINT_START.length(), literalValue.length() - POINT_END.length());
            String[] split = valueString.split(POINT_SEPERATOR);
            if (split.length != 2) {
                return false;
            }
            try {
                Double.parseDouble(split[0]);
                Double.parseDouble(split[1]);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }
        throw new LiteralUtilException("Did not recognise datatype");
    }
}

