# -*- coding: utf-8 -*-
"""Initial migration

Revision ID: 0001.outflow.management
Revises:
Create Date: 2020-11-19 13:43:50.767650

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "0001.outflow.management"
down_revision = None
branch_labels = ("outflow.management",)
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "configuration",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("config", sa.JSON(), nullable=False),
        sa.Column("settings", sa.JSON(), nullable=False),
        sa.Column("hash", sa.String(length=64), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("hash"),
    )
    op.grant_permissions("configuration")
    op.create_table(
        "run",
        sa.Column("uuid", sa.String(length=36), nullable=False),
        sa.Column("start_time", sa.DateTime(), nullable=True),
        sa.Column("end_time", sa.DateTime(), nullable=True),
        sa.Column(
            "state",
            sa.Enum("pending", "running", "failed", "success", name="stateenum"),
            nullable=False,
        ),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("configuration_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["configuration_id"],
            ["configuration.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("uuid"),
    )
    op.grant_permissions("run")
    op.create_table(
        "task",
        sa.Column("uuid", sa.String(length=36), nullable=False),
        sa.Column("start_time", sa.DateTime(), nullable=True),
        sa.Column("end_time", sa.DateTime(), nullable=True),
        sa.Column(
            "state",
            sa.Enum("pending", "running", "failed", "success", name="stateenum"),
            nullable=False,
        ),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("plugin", sa.String(length=256), nullable=True),
        sa.Column("name", sa.String(length=256), nullable=False),
        sa.Column("run_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["run_id"],
            ["run.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("uuid"),
    )
    op.grant_permissions("task")
    op.create_table(
        "edge",
        sa.Column("upstream_task_id", sa.Integer(), nullable=False),
        sa.Column("downstream_task_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["downstream_task_id"],
            ["task.id"],
        ),
        sa.ForeignKeyConstraint(
            ["upstream_task_id"],
            ["task.id"],
        ),
        sa.PrimaryKeyConstraint("upstream_task_id", "downstream_task_id"),
    )
    op.grant_permissions("edge")
    op.create_table(
        "runtime_exception",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("task_id", sa.Integer(), nullable=True),
        sa.Column("exception_type", sa.String(length=64), nullable=False),
        sa.Column("exception_msg", sa.Text(), nullable=False),
        sa.Column("time", sa.DateTime(), nullable=False),
        sa.Column("traceback", sa.Text(), nullable=False),
        sa.ForeignKeyConstraint(
            ["task_id"],
            ["task.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.grant_permissions("runtime_exception")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("runtime_exception")
    op.drop_table("configuration")
    op.drop_table("task")
    op.drop_table("run")
    op.drop_table("edge")
    # ### end Alembic commands ###
