"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBInstance = exports.DBInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const polardb_generated_1 = require("./polardb.generated");
Object.defineProperty(exports, "DBInstanceProperty", { enumerable: true, get: function () { return polardb_generated_1.RosDBInstance; } });
/**
 * A ROS resource type:  `ALIYUN::POLARDB::DBInstance`
 */
class DBInstance extends ros.Resource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the properties of this ROS resource, which will be assigned to ROS resource.
     */
    /**
     * Create a new `ALIYUN::POLARDB::DBInstance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBInstance = new polardb_generated_1.RosDBInstance(this, id, {
            characterSetName: props.characterSetName,
            accountPrivilege: props.accountPrivilege ? props.accountPrivilege : 'ReadWrite',
            dbDescription: props.dbDescription,
            dbClusterId: props.dbClusterId,
            dbName: props.dbName,
            accountName: props.accountName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBInstance;
    }
}
exports.DBInstance = DBInstance;
//# sourceMappingURL=data:application/json;base64,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