"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBClusterEndpointAddress = exports.DBClusterEndpointAddressProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const polardb_generated_1 = require("./polardb.generated");
Object.defineProperty(exports, "DBClusterEndpointAddressProperty", { enumerable: true, get: function () { return polardb_generated_1.RosDBClusterEndpointAddress; } });
/**
 * A ROS resource type:  `ALIYUN::POLARDB::DBClusterEndpointAddress`
 */
class DBClusterEndpointAddress extends ros.Resource {
    /**
     * Create a new `ALIYUN::POLARDB::DBClusterEndpointAddress`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBClusterEndpointAddress = new polardb_generated_1.RosDBClusterEndpointAddress(this, id, {
            dbEndpointId: props.dbEndpointId,
            dbClusterId: props.dbClusterId,
            connectionStringPrefix: props.connectionStringPrefix,
            netType: props.netType ? props.netType : 'Public',
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBClusterEndpointAddress;
        this.attrAddress = rosDBClusterEndpointAddress.attrAddress;
        this.attrConnectionString = rosDBClusterEndpointAddress.attrConnectionString;
    }
}
exports.DBClusterEndpointAddress = DBClusterEndpointAddress;
//# sourceMappingURL=data:application/json;base64,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