"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBClusterEndpoint = exports.DBClusterEndpointProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const polardb_generated_1 = require("./polardb.generated");
Object.defineProperty(exports, "DBClusterEndpointProperty", { enumerable: true, get: function () { return polardb_generated_1.RosDBClusterEndpoint; } });
/**
 * A ROS resource type:  `ALIYUN::POLARDB::DBClusterEndpoint`
 */
class DBClusterEndpoint extends ros.Resource {
    /**
     * Create a new `ALIYUN::POLARDB::DBClusterEndpoint`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBClusterEndpoint = new polardb_generated_1.RosDBClusterEndpoint(this, id, {
            autoAddNewNodes: props.autoAddNewNodes ? props.autoAddNewNodes : 'Disable',
            dbClusterId: props.dbClusterId,
            endpointType: props.endpointType ? props.endpointType : 'Custom',
            readWriteMode: props.readWriteMode ? props.readWriteMode : 'ReadOnly',
            endpointConfig: props.endpointConfig,
            nodes: props.nodes,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBClusterEndpoint;
        this.attrAddresses = rosDBClusterEndpoint.attrAddresses;
        this.attrConnectionString = rosDBClusterEndpoint.attrConnectionString;
        this.attrDbEndpointId = rosDBClusterEndpoint.attrDbEndpointId;
    }
}
exports.DBClusterEndpoint = DBClusterEndpoint;
//# sourceMappingURL=data:application/json;base64,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