"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBClusterAccessWhiteList = exports.DBClusterAccessWhiteListProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const polardb_generated_1 = require("./polardb.generated");
Object.defineProperty(exports, "DBClusterAccessWhiteListProperty", { enumerable: true, get: function () { return polardb_generated_1.RosDBClusterAccessWhiteList; } });
/**
 * A ROS resource type:  `ALIYUN::POLARDB::DBClusterAccessWhiteList`
 */
class DBClusterAccessWhiteList extends ros.Resource {
    /**
     * Create a new `ALIYUN::POLARDB::DBClusterAccessWhiteList`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBClusterAccessWhiteList = new polardb_generated_1.RosDBClusterAccessWhiteList(this, id, {
            securityIps: props.securityIps,
            dbClusterIpArrayName: props.dbClusterIpArrayName,
            dbClusterId: props.dbClusterId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBClusterAccessWhiteList;
        this.attrDbClusterId = rosDBClusterAccessWhiteList.attrDbClusterId;
    }
}
exports.DBClusterAccessWhiteList = DBClusterAccessWhiteList;
//# sourceMappingURL=data:application/json;base64,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