"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBCluster = exports.DBClusterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const polardb_generated_1 = require("./polardb.generated");
Object.defineProperty(exports, "DBClusterProperty", { enumerable: true, get: function () { return polardb_generated_1.RosDBCluster; } });
/**
 * A ROS resource type:  `ALIYUN::POLARDB::DBCluster`
 */
class DBCluster extends ros.Resource {
    /**
     * Create a new `ALIYUN::POLARDB::DBCluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBCluster = new polardb_generated_1.RosDBCluster(this, id, {
            autoRenewPeriod: props.autoRenewPeriod ? props.autoRenewPeriod : 1,
            defaultTimeZone: props.defaultTimeZone,
            tdeStatus: props.tdeStatus,
            cloneDataPoint: props.cloneDataPoint ? props.cloneDataPoint : 'LATEST',
            gdnId: props.gdnId,
            resourceGroupId: props.resourceGroupId,
            zoneId: props.zoneId,
            vSwitchId: props.vSwitchId,
            backupRetentionPolicyOnClusterDeletion: props.backupRetentionPolicyOnClusterDeletion,
            renewalStatus: props.renewalStatus ? props.renewalStatus : 'Normal',
            dbClusterDescription: props.dbClusterDescription,
            period: props.period,
            sourceResourceId: props.sourceResourceId,
            dbType: props.dbType,
            payType: props.payType,
            creationCategory: props.creationCategory,
            dbNodeClass: props.dbNodeClass,
            creationOption: props.creationOption ? props.creationOption : 'Normal',
            dbVersion: props.dbVersion,
            clusterNetworkType: props.clusterNetworkType ? props.clusterNetworkType : 'VPC',
            vpcId: props.vpcId,
            securityIpList: props.securityIpList,
            maintainTime: props.maintainTime,
            lowerCaseTableNames: props.lowerCaseTableNames,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBCluster;
        this.attrClusterConnectionString = rosDBCluster.attrClusterConnectionString;
        this.attrClusterEndpointId = rosDBCluster.attrClusterEndpointId;
        this.attrCustomConnectionStrings = rosDBCluster.attrCustomConnectionStrings;
        this.attrCustomEndpointIds = rosDBCluster.attrCustomEndpointIds;
        this.attrDbClusterId = rosDBCluster.attrDbClusterId;
        this.attrDbNodeIds = rosDBCluster.attrDbNodeIds;
        this.attrOrderId = rosDBCluster.attrOrderId;
        this.attrPrimaryConnectionString = rosDBCluster.attrPrimaryConnectionString;
        this.attrPrimaryEndpointId = rosDBCluster.attrPrimaryEndpointId;
    }
}
exports.DBCluster = DBCluster;
//# sourceMappingURL=data:application/json;base64,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