"""
    Perun RPC API

    Perun Remote Procedure Calls Application Programming Interface  # noqa: E501

    The version of the OpenAPI document: 0.0.0
    Contact: perun@cesnet.cz
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from perun.connector.perun_openapi.api_client import ApiClient, Endpoint as _Endpoint
from perun.connector.perun_openapi.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from perun.connector.perun_openapi.model.perun_exception import PerunException
from perun.connector.perun_openapi.model.rt_message import RTMessage


class RTMessagesManagerApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.sent_message_to_rt_with_member_queue_endpoint = _Endpoint(
            settings={
                'response_type': (RTMessage,),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/urlinjsonout/rtMessagesManager/sentMessageToRT/m-q',
                'operation_id': 'sent_message_to_rt_with_member_queue',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_id',
                    'queue',
                    'subject',
                    'text',
                ],
                'required': [
                    'member_id',
                    'queue',
                    'subject',
                    'text',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_id':
                        (int,),
                    'queue':
                        (str,),
                    'subject':
                        (str,),
                    'text':
                        (str,),
                },
                'attribute_map': {
                    'member_id': 'memberId',
                    'queue': 'queue',
                    'subject': 'subject',
                    'text': 'text',
                },
                'location_map': {
                    'member_id': 'query',
                    'queue': 'query',
                    'subject': 'query',
                    'text': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.sent_message_to_rt_with_queue_endpoint = _Endpoint(
            settings={
                'response_type': (RTMessage,),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/urlinjsonout/rtMessagesManager/sentMessageToRT/q',
                'operation_id': 'sent_message_to_rt_with_queue',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'queue',
                    'subject',
                    'text',
                ],
                'required': [
                    'queue',
                    'subject',
                    'text',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'queue':
                        (str,),
                    'subject':
                        (str,),
                    'text':
                        (str,),
                },
                'attribute_map': {
                    'queue': 'queue',
                    'subject': 'subject',
                    'text': 'text',
                },
                'location_map': {
                    'queue': 'query',
                    'subject': 'query',
                    'text': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.sent_message_to_rt_with_vo_endpoint = _Endpoint(
            settings={
                'response_type': (RTMessage,),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/urlinjsonout/rtMessagesManager/sentMessageToRT/v',
                'operation_id': 'sent_message_to_rt_with_vo',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vo_id',
                    'subject',
                    'text',
                ],
                'required': [
                    'vo_id',
                    'subject',
                    'text',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vo_id':
                        (int,),
                    'subject':
                        (str,),
                    'text':
                        (str,),
                },
                'attribute_map': {
                    'vo_id': 'voId',
                    'subject': 'subject',
                    'text': 'text',
                },
                'location_map': {
                    'vo_id': 'query',
                    'subject': 'query',
                    'text': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.sent_message_to_rt_with_vo_queue_endpoint = _Endpoint(
            settings={
                'response_type': (RTMessage,),
                'auth': [
                    'BasicAuth',
                    'BearerAuth'
                ],
                'endpoint_path': '/urlinjsonout/rtMessagesManager/sentMessageToRT/v-q',
                'operation_id': 'sent_message_to_rt_with_vo_queue',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vo_id',
                    'queue',
                    'subject',
                    'text',
                ],
                'required': [
                    'vo_id',
                    'queue',
                    'subject',
                    'text',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vo_id':
                        (int,),
                    'queue':
                        (str,),
                    'subject':
                        (str,),
                    'text':
                        (str,),
                },
                'attribute_map': {
                    'vo_id': 'voId',
                    'queue': 'queue',
                    'subject': 'subject',
                    'text': 'text',
                },
                'location_map': {
                    'vo_id': 'query',
                    'queue': 'query',
                    'subject': 'query',
                    'text': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def sent_message_to_rt_with_member_queue(
        self,
        member_id,
        queue,
        subject,
        text,
        **kwargs
    ):
        """Sends a message to RT. Member id is sent.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sent_message_to_rt_with_member_queue(member_id, queue, subject, text, async_req=True)
        >>> result = thread.get()

        Args:
            member_id (int): Member whose e-mail address will be user
            queue (str): RT queue
            subject (str): Message subject
            text (str): Message text

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RTMessage
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['member_id'] = \
            member_id
        kwargs['queue'] = \
            queue
        kwargs['subject'] = \
            subject
        kwargs['text'] = \
            text
        return self.sent_message_to_rt_with_member_queue_endpoint.call_with_http_info(**kwargs)

    def sent_message_to_rt_with_queue(
        self,
        queue,
        subject,
        text,
        **kwargs
    ):
        """Sends a message to RT. Only text information is sent.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sent_message_to_rt_with_queue(queue, subject, text, async_req=True)
        >>> result = thread.get()

        Args:
            queue (str): RT queue
            subject (str): Message subject
            text (str): Message text

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RTMessage
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['queue'] = \
            queue
        kwargs['subject'] = \
            subject
        kwargs['text'] = \
            text
        return self.sent_message_to_rt_with_queue_endpoint.call_with_http_info(**kwargs)

    def sent_message_to_rt_with_vo(
        self,
        vo_id,
        subject,
        text,
        **kwargs
    ):
        """Sends a message to RT. VO id is sent. Queue is not sent.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sent_message_to_rt_with_vo(vo_id, subject, text, async_req=True)
        >>> result = thread.get()

        Args:
            vo_id (int): VO id
            subject (str): Message subject
            text (str): Message text

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RTMessage
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['vo_id'] = \
            vo_id
        kwargs['subject'] = \
            subject
        kwargs['text'] = \
            text
        return self.sent_message_to_rt_with_vo_endpoint.call_with_http_info(**kwargs)

    def sent_message_to_rt_with_vo_queue(
        self,
        vo_id,
        queue,
        subject,
        text,
        **kwargs
    ):
        """Sends a message to RT. VO id is sent.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sent_message_to_rt_with_vo_queue(vo_id, queue, subject, text, async_req=True)
        >>> result = thread.get()

        Args:
            vo_id (int): VO id
            queue (str): RT queue
            subject (str): Message subject
            text (str): Message text

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RTMessage
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['vo_id'] = \
            vo_id
        kwargs['queue'] = \
            queue
        kwargs['subject'] = \
            subject
        kwargs['text'] = \
            text
        return self.sent_message_to_rt_with_vo_queue_endpoint.call_with_http_info(**kwargs)

