# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-06-18 19:35
from __future__ import unicode_literals

import uuid

import django.db.models.deletion
import opaque_keys.edx.django.models
from django.db import migrations, models

import eox_tagging.constants


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='OpaqueKeyProxyModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('opaque_key', opaque_keys.edx.django.models.CourseKeyField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('key', models.UUIDField(default=uuid.uuid4, editable=False, unique=True, verbose_name=b'Public identifier')),
                ('tag_value', models.CharField(max_length=150)),
                ('tag_type', models.CharField(max_length=150)),
                ('access', models.PositiveIntegerField(choices=[(1, b'PUBLIC'), (2, b'PROTECTED'), (3, b'PRIVATE')], default=eox_tagging.constants.AccessLevel(1))),
                ('activation_date', models.DateField(blank=True, null=True)),
                ('expiration_date', models.DateField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('status', models.PositiveIntegerField(choices=[(0, b'INVALID'), (1, b'VALID')], default=eox_tagging.constants.Status(1), editable=False)),
                ('invalidated_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('target_object_id', models.PositiveIntegerField(blank=True, null=True)),
                ('owner_object_id', models.PositiveIntegerField(blank=True, null=True)),
                ('owner_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='owner_tag_type', to='contenttypes.ContentType')),
                ('target_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='tag_type', to='contenttypes.ContentType')),
            ],
            options={
                'verbose_name': 'tag',
                'verbose_name_plural': 'tags',
            },
        ),
    ]
