import unittest

from pyvalidator import *


class TestIsPort(unittest.TestCase):

    def test_valid_semantic_version(self):
        self.assertTrue(is_semantic_version('0.0.4'))
        self.assertTrue(is_semantic_version('1.2.3'))
        self.assertTrue(is_semantic_version('10.20.30'))
        self.assertTrue(is_semantic_version('1.1.2-prerelease+meta'))
        self.assertTrue(is_semantic_version('1.1.2+meta'))
        self.assertTrue(is_semantic_version('1.1.2+meta-valid'))
        self.assertTrue(is_semantic_version('1.0.0-alpha'))
        self.assertTrue(is_semantic_version('1.0.0-beta'))
        self.assertTrue(is_semantic_version('1.0.0-alpha.beta'))
        self.assertTrue(is_semantic_version('1.0.0-alpha.beta.1'))
        self.assertTrue(is_semantic_version('1.0.0-alpha.1'))
        self.assertTrue(is_semantic_version('1.0.0-alpha0.valid'))
        self.assertTrue(is_semantic_version('1.0.0-alpha.0valid'))
        self.assertTrue(is_semantic_version('1.0.0-alpha-a.b-c-somethinglong+build.1-aef.1-its-okay'))
        self.assertTrue(is_semantic_version('1.0.0-rc.1+build.1'))
        self.assertTrue(is_semantic_version('2.0.0-rc.1+build.123'))
        self.assertTrue(is_semantic_version('1.2.3-beta'))
        self.assertTrue(is_semantic_version('10.2.3-DEV-SNAPSHOT'))
        self.assertTrue(is_semantic_version('1.2.3-SNAPSHOT-123'))
        self.assertTrue(is_semantic_version('1.0.0'))
        self.assertTrue(is_semantic_version('2.0.0'))
        self.assertTrue(is_semantic_version('1.1.7'))
        self.assertTrue(is_semantic_version('2.0.0+build.1848'))
        self.assertTrue(is_semantic_version('2.0.1-alpha.1227'))
        self.assertTrue(is_semantic_version('1.0.0-alpha+beta'))
        self.assertTrue(is_semantic_version('1.2.3----RC-SNAPSHOT.12.9.1--.12+788'))
        self.assertTrue(is_semantic_version('1.2.3----R-S.12.9.1--.12+meta'))
        self.assertTrue(is_semantic_version('1.2.3----RC-SNAPSHOT.12.9.1--.12'))
        self.assertTrue(is_semantic_version('1.0.0+0.build.1-rc.10000aaa-kk-0.1'))
        self.assertTrue(is_semantic_version('99999999999999999999999.999999999999999999.99999999999999999'))
        self.assertTrue(is_semantic_version('1.0.0-0A.is.legal'))
        print('OK - test_valid_semantic_version')

    def test_invalid_semantic_version(self):
        self.assertFalse(is_semantic_version(''))
        self.assertFalse(is_semantic_version('...'))
        self.assertFalse(is_semantic_version('-invalid+invalid'))
        self.assertFalse(is_semantic_version('-invalid.01'))
        self.assertFalse(is_semantic_version('alpha'))
        self.assertFalse(is_semantic_version('alpha.beta'))
        self.assertFalse(is_semantic_version('alpha.beta.1'))
        self.assertFalse(is_semantic_version('alpha.1'))
        self.assertFalse(is_semantic_version('alpha+beta'))
        self.assertFalse(is_semantic_version('alpha_beta'))
        self.assertFalse(is_semantic_version('alpha.'))
        self.assertFalse(is_semantic_version('alpha..'))
        self.assertFalse(is_semantic_version('beta'))
        self.assertFalse(is_semantic_version('1.0.0-alpha_beta'))
        self.assertFalse(is_semantic_version('-alpha.'))
        self.assertFalse(is_semantic_version('1.0.0-alpha..'))
        self.assertFalse(is_semantic_version('1.0.0-alpha..1'))
        self.assertFalse(is_semantic_version('1.0.0-alpha...1'))
        self.assertFalse(is_semantic_version('1.0.0-alpha....1'))
        self.assertFalse(is_semantic_version('1.0.0-alpha.....1'))
        self.assertFalse(is_semantic_version('1.0.0-alpha......1'))
        self.assertFalse(is_semantic_version('1.0.0-alpha.......1'))
        self.assertFalse(is_semantic_version('01.1.1'))
        self.assertFalse(is_semantic_version('1.01.1'))
        self.assertFalse(is_semantic_version('1.1.01'))
        self.assertFalse(is_semantic_version('1.2'))
        self.assertFalse(is_semantic_version('1.2.3.DEV'))
        self.assertFalse(is_semantic_version('1.2-SNAPSHOT'))
        self.assertFalse(is_semantic_version('1.2.31.2.3----RC-SNAPSHOT.12.09.1--..12+788'))
        self.assertFalse(is_semantic_version('1.2-RC-SNAPSHOT'))
        self.assertFalse(is_semantic_version('-1.0.3-gamma+b7718'))
        self.assertFalse(is_semantic_version('+justmeta'))
        self.assertFalse(is_semantic_version('9.8.7+meta+meta'))
        self.assertFalse(is_semantic_version('9.8.7-whatever+meta+meta'))
        self.assertFalse(is_semantic_version('99999999999999999999999.999999999999999999.99999999999999999-'))
        self.assertFalse(is_semantic_version('--SSS.RC-UPDATE.13.19.2---------..13'))
        print('OK - test_invalid_semantic_version')
