""""Users Mutation."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

from typing import TYPE_CHECKING, Any, List, Dict, Optional, Tuple, Union

from taegis_sdk_python.utils import build_output_string, prepare_input
from taegis_sdk_python.services.users.types import *

from taegis_sdk_python import GraphQLNoRowsInResultSetError

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.users import UsersService


class TaegisSDKUsersMutation:
    """Teagis Users Mutation operations."""

    def __init__(self, service: UsersService):
        self.service = service

    def forgot_password(self, email: str) -> ForgotPasswordResponse:
        """Initiate the password reset workflow requested by a user."""
        endpoint = "forgotPassword"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "email": prepare_input(email),
            },
            output=build_output_string(ForgotPasswordResponse),
        )
        if result is not None:
            return ForgotPasswordResponse.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation forgotPassword")

    def reset_password(self, reset_input: PasswordResetInput) -> ForgotPasswordResponse:
        """Set/reset the password for the specified user."""
        endpoint = "resetPassword"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "resetInput": prepare_input(reset_input),
            },
            output=build_output_string(ForgotPasswordResponse),
        )
        if result is not None:
            return ForgotPasswordResponse.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation resetPassword")

    def need_mfa_reset(self, email: str) -> ForgotPasswordResponse:
        """Initiate the MFA reset workflow requested by a user."""
        endpoint = "needMFAReset"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "email": prepare_input(email),
            },
            output=build_output_string(ForgotPasswordResponse),
        )
        if result is not None:
            return ForgotPasswordResponse.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation needMFAReset")

    def reset_mfa(self, mfa_input: MFAResetInput) -> MFAResetResponse:
        """Set/reset the password for the specified user."""
        endpoint = "resetMFA"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "mfaInput": prepare_input(mfa_input),
            },
            output=build_output_string(MFAResetResponse),
        )
        if result is not None:
            return MFAResetResponse.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation resetMFA")

    def register_tdruser(
        self, registration_input: UserRegistrationInput
    ) -> MFAResetResponse:
        """Process user registration from invites."""
        endpoint = "registerTDRUser"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "registrationInput": prepare_input(registration_input),
            },
            output=build_output_string(MFAResetResponse),
        )
        if result is not None:
            return MFAResetResponse.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation registerTDRUser")
