""""Rules Mutation."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

from typing import TYPE_CHECKING, Any, List, Dict, Optional, Tuple, Union

from taegis_sdk_python.utils import build_output_string, prepare_input
from taegis_sdk_python.services.rules.types import *

from taegis_sdk_python import GraphQLNoRowsInResultSetError

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.rules import RulesService


class TaegisSDKRulesMutation:
    """Teagis Rules Mutation operations."""

    def __init__(self, service: RulesService):
        self.service = service

    def create_custom_ql_rule(
        self, input_: RuleInput, ql_filter: RuleQLFilterInput
    ) -> Rule:
        """Create the given new custom rule, with optional filters."""
        endpoint = "createCustomQLRule"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
                "qlFilter": prepare_input(ql_filter),
            },
            output=build_output_string(Rule),
        )
        if result is not None:
            return Rule.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createCustomQLRule")

    def create_custom_suppression_rule(
        self, input_: RuleInput, filters: List[RuleFilterInput]
    ) -> Rule:
        """Create a custom suppression rule, with at least one filter."""
        endpoint = "createCustomSuppressionRule"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
                "filters": prepare_input(filters),
            },
            output=build_output_string(Rule),
        )
        if result is not None:
            return Rule.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createCustomSuppressionRule")

    def create_rule(self, input_: RuleInput, filters: List[RuleFilterInput]) -> Rule:
        """Create the given new rule, with optional filters."""
        endpoint = "createRule"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
                "filters": prepare_input(filters),
            },
            output=build_output_string(Rule),
        )
        if result is not None:
            return Rule.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createRule")

    def create_suppression_rule(
        self, input_: RuleInput, filters: List[RuleFilterInput]
    ) -> Rule:
        """Create a suppression rule with at least one filter."""
        endpoint = "createSuppressionRule"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
                "filters": prepare_input(filters),
            },
            output=build_output_string(Rule),
        )
        if result is not None:
            return Rule.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createSuppressionRule")

    def create_event_tagging_rule(
        self, input_: RuleInput, filters: List[RuleFilterInput]
    ) -> Rule:
        """Creates an event tagging rule with at least one filter."""
        endpoint = "createEventTaggingRule"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
                "filters": prepare_input(filters),
            },
            output=build_output_string(Rule),
        )
        if result is not None:
            return Rule.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createEventTaggingRule")

    def create_ql_event_tagging_rule(
        self, input_: RuleInput, ql_filter: RuleQLFilterInput
    ) -> Rule:
        """Creates an event tagging rule with a QL filter."""
        endpoint = "createQLEventTaggingRule"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
                "qlFilter": prepare_input(ql_filter),
            },
            output=build_output_string(Rule),
        )
        if result is not None:
            return Rule.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createQLEventTaggingRule")

    def add_filter_to_rule(self, rule_id: str, filter_: RuleFilterInput) -> RuleFilter:
        """Add the provided filter to the rule with the given ID."""
        endpoint = "addFilterToRule"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "ruleID": prepare_input(rule_id),
                "filter": prepare_input(filter_),
            },
            output=build_output_string(RuleFilter),
        )
        if result is not None:
            return RuleFilter.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation addFilterToRule")

    def update_rule(self, rule_id: str, rule: RuleInput) -> Rule:
        """Update the given rule, without changing the filters."""
        endpoint = "updateRule"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "ruleID": prepare_input(rule_id),
                "rule": prepare_input(rule),
            },
            output=build_output_string(Rule),
        )
        if result is not None:
            return Rule.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation updateRule")

    def delete_rule(self, rule_id: str, hard: Optional[bool] = None) -> Rule:
        """Delete the given rule. This is normally a soft delete and can be undone with restoreRule.

        If the hard parameter is true this will be a permanent hard deletion. Only do this with care!

        Note some users may not have permission to do a hard delete.

        The rule with also be disabled.."""
        endpoint = "deleteRule"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "ruleID": prepare_input(rule_id),
                "hard": prepare_input(hard),
            },
            output=build_output_string(Rule),
        )
        if result is not None:
            return Rule.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation deleteRule")

    def restore_rule(self, rule_id: str) -> Rule:
        """Restore the given rule from deleted status.

        It will remain disabled from being deleted and can be enabled with enableRule.."""
        endpoint = "restoreRule"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "ruleID": prepare_input(rule_id),
            },
            output=build_output_string(Rule),
        )
        if result is not None:
            return Rule.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation restoreRule")

    def update_filter(self, filter_id: str, filter_: RuleFilterInput) -> RuleFilter:
        """Update the given filter."""
        endpoint = "updateFilter"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "filterID": prepare_input(filter_id),
                "filter": prepare_input(filter_),
            },
            output=build_output_string(RuleFilter),
        )
        if result is not None:
            return RuleFilter.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation updateFilter")

    def update_filters(
        self,
        rule_id: str,
        filters: List[RuleFilterInput],
        replace: Optional[bool] = None,
    ) -> List[RuleFilter]:
        """Bulk update the given list of filters for the given Rule ID.

        Existing filters should have the ID field provided in RuleFilterInput. New
        filters should not have that ID and will be added to the rule in the order
        provided.

        Multiple errors will be returned for each filter which fails validation. Any
        errors will make the entire update fail.."""
        endpoint = "updateFilters"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "ruleID": prepare_input(rule_id),
                "filters": prepare_input(filters),
                "replace": prepare_input(replace),
            },
            output=build_output_string(RuleFilter),
        )
        if result is not None:
            return RuleFilter.schema().load(result.get(endpoint), many=True)
        raise GraphQLNoRowsInResultSetError("for mutation updateFilters")

    def delete_filter(self, filter_id: str) -> RuleFilter:
        """Delete the given Regex filter, and return it."""
        endpoint = "deleteFilter"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "filterID": prepare_input(filter_id),
            },
            output=build_output_string(RuleFilter),
        )
        if result is not None:
            return RuleFilter.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation deleteFilter")

    def create_ql_rule(self, input_: RuleInput, ql_filter: RuleQLFilterInput) -> Rule:
        """Create the given new rule with a QL filter."""
        endpoint = "createQLRule"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
                "qlFilter": prepare_input(ql_filter),
            },
            output=build_output_string(Rule),
        )
        if result is not None:
            return Rule.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createQLRule")

    def update_ql_filter(
        self, filter_id: str, ql_filter: RuleQLFilterInput
    ) -> RuleQLFilter:
        """Update the given QL Filter."""
        endpoint = "updateQLFilter"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "filterID": prepare_input(filter_id),
                "qlFilter": prepare_input(ql_filter),
            },
            output=build_output_string(RuleQLFilter),
        )
        if result is not None:
            return RuleQLFilter.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation updateQLFilter")

    def disable_rule(self, id_: str) -> Rule:
        """Disable the rule with the given ID."""
        endpoint = "disableRule"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(Rule),
        )
        if result is not None:
            return Rule.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation disableRule")

    def enable_rule(self, id_: str) -> Rule:
        """Enable the rule with the given ID."""
        endpoint = "enableRule"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(Rule),
        )
        if result is not None:
            return Rule.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation enableRule")

    def create_red_ql_rule(
        self, input_: RuleInput, red_ql_filter: RuleRedQLFilterInput
    ) -> Rule:
        """DEPRECATED: Please use the createQLRule mutation to create QL rules. If this
        mutation is used, it will create a QL rule which will have the same filter
        in both the qlFilter and redQLFilter fields.

        Create the given new rule with a QL filter."""
        endpoint = "createRedQLRule"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
                "redQLFilter": prepare_input(red_ql_filter),
            },
            output=build_output_string(Rule),
        )
        if result is not None:
            return Rule.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createRedQLRule")

    def update_red_ql_filter(
        self, filter_id: str, red_ql_filter: RuleRedQLFilterInput
    ) -> RuleRedQLFilter:
        """DEPRECATED: Please use the updateQLFilter mutation to update QL filters. If this
        mutation is used, it will update the QL filter which is returned in both the
        qlFilter and redLQFilter fields of the rule which owns this filter.

        Update the given QL Filter."""
        endpoint = "updateRedQLFilter"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "filterID": prepare_input(filter_id),
                "redQLFilter": prepare_input(red_ql_filter),
            },
            output=build_output_string(RuleRedQLFilter),
        )
        if result is not None:
            return RuleRedQLFilter.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation updateRedQLFilter")
