""""EndpointCommandManager Query."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

from typing import TYPE_CHECKING, Any, List, Dict, Optional, Tuple, Union

from taegis_sdk_python.utils import build_output_string, prepare_input
from taegis_sdk_python.services.endpoint_command_manager.types import *

from taegis_sdk_python import GraphQLNoRowsInResultSetError

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.endpoint_command_manager import (
        EndpointCommandManagerService,
    )


class TaegisSDKEndpointCommandManagerQuery:
    """Teagis Endpoint_command_manager Query operations."""

    def __init__(self, service: EndpointCommandManagerService):
        self.service = service

    def endpoint_uninstall_status(self, arguments: UninstallStateArguments) -> bool:
        """None."""
        endpoint = "endpointUninstallStatus"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output="",
        )
        if result is not None:
            return result.get(endpoint)
        raise GraphQLNoRowsInResultSetError("for query endpointUninstallStatus")

    def endpoint_command_history(
        self, arguments: CommandHistoryArguments
    ) -> List[HistoryEntry]:
        """None."""
        endpoint = "endpointCommandHistory"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(HistoryEntry),
        )
        if result is not None:
            return HistoryEntry.schema().load(result.get(endpoint), many=True)
        raise GraphQLNoRowsInResultSetError("for query endpointCommandHistory")

    def endpoint_isolation_exclusion_rules(self) -> List[IsolationExclusionRule]:
        """None."""
        endpoint = "endpointIsolationExclusionRules"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={},
            output=build_output_string(IsolationExclusionRule),
        )
        if result is not None:
            return IsolationExclusionRule.schema().load(result.get(endpoint), many=True)
        raise GraphQLNoRowsInResultSetError("for query endpointIsolationExclusionRules")
