""""Alerts Subscription."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

from typing import TYPE_CHECKING, Any, List, Dict, Optional, Tuple, Union

from taegis_sdk_python.utils import build_output_string, prepare_input
from taegis_sdk_python.services.alerts.types import *

from taegis_sdk_python import GraphQLNoRowsInResultSetError

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.alerts import AlertsService


class TaegisSDKAlertsSubscription:
    """Teagis Alerts Subscription operations."""

    def __init__(self, service: AlertsService):
        self.service = service

    def alerts_service_bulk_resolution_processor(
        self, in_: Optional[BulkResolutionRequestInput] = None
    ) -> List[BulkResolutionResponse]:
        """Add a resolution or modify an existing resolution for multiple alerts selected with a CQL query.."""
        endpoint = "alertsServiceBulkResolutionProcessor"

        result = self.service.execute_subscription(
            endpoint=endpoint,
            variables={
                "in": prepare_input(in_),
            },
            output=build_output_string(BulkResolutionResponse),
        )
        if result is not None:
            return BulkResolutionResponse.schema().load(
                [r.get(endpoint) for r in result], many=True
            )
        raise GraphQLNoRowsInResultSetError(
            "for subscription alertsServiceBulkResolutionProcessor"
        )
